/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class StoreableSaveCommand<K, V extends Storeable>
extends AcknowledgedCommand<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private K k;
    private Storeable v;
    private long version;
    private transient byte[] rawReadState;
    private boolean wasFullWrite;
    private DataStoreEntry<K, V> entry;
    private String replicaChoices;

    public StoreableSaveCommand() {
        super((byte)68);
    }

    public StoreableSaveCommand(K k, V v) {
        this();
        this.setKey(k);
        this.setValue(v);
        this.version = v._storeable_getVersion();
    }

    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
        this.version = v._storeable_getVersion();
    }

    public DataStoreEntry<K, V> getEntry() {
        return this.entry;
    }

    public void setEntry(DataStoreEntry<K, V> entry) {
        this.entry = entry;
    }

    @Override
    protected StoreableSaveCommand<K, V> createNewInstance() {
        return new StoreableSaveCommand<K, V>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        if (!this.dsc.isDoASyncReplication()) {
            super.writeAcknowledgementId(ros);
        }
        this.version = this.v._storeable_getVersion();
        boolean requiresFullSave = true;
        if (this.entry.getReplicaInstanceName() != null) {
            requiresFullSave = !this.entry.getReplicaInstanceName().equals(this.getTargetName());
        }
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.k);
        ros.writeLong(this.v._storeable_getVersion());
        ros.writeBoolean(requiresFullSave);
        if (requiresFullSave) {
            this.dsc.getDataStoreEntryHelper().writeObject(ros, this.v);
        } else {
            byte[] data = new byte[]{};
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.v._storeable_writeState((OutputStream)bos);
                data = bos.toByteArray();
            }
            finally {
                try {
                    bos.close();
                }
                catch (Exception ex) {}
            }
            ros.writeLengthPrefixedBytes(data);
        }
    }

    @Override
    public boolean computeTarget() {
        this.replicaChoices = this.dsc.getKeyMapper().getReplicaChoices(this.dsc.getGroupName(), this.k);
        String[] choices = this.replicaChoices == null ? null : this.replicaChoices.split(":");
        super.setTargetName(this.replicaChoices == null ? null : choices[0]);
        return this.getTargetName() != null;
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        if (!this.dsc.isDoASyncReplication()) {
            super.readAcknowledgementId(ris);
        }
        this.k = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.version = ris.readLong();
        this.wasFullWrite = ris.readBoolean();
        if (this.wasFullWrite) {
            this.v = (Storeable)this.dsc.getDataStoreEntryHelper().readObject(ris);
        } else {
            this.rawReadState = ris.readLengthPrefixedBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.k);
        synchronized (dataStoreEntry) {
            if (this.wasFullWrite) {
                entry.setV(this.v);
                entry.clearPendingUpdates();
            } else {
                Storeable entryV = (Storeable)entry.getV();
                if (entryV != null) {
                    if (entryV._storeable_getVersion() <= this.version) {
                        ByteArrayInputStream bis = new ByteArrayInputStream(this.rawReadState);
                        try {
                            entryV._storeable_readState((InputStream)bis);
                        }
                        catch (IOException ex) {
                            throw new DataStoreException(ex);
                        }
                        finally {
                            try {
                                bis.close();
                            }
                            catch (Exception ex2) {}
                        }
                    }
                    if (entryV._storeable_getVersion() > this.version) {
                        _logger.log(Level.WARNING, "Ignoring stale data " + entryV._storeable_getVersion() + " > " + this.version + "; for key: " + this.k);
                    }
                } else {
                    List commands = entry.getPendingUpdates();
                    _logger.log(Level.WARNING, "Added to pending updates[2].... for key: " + this.k);
                }
            }
        }
        if (!this.dsc.isDoASyncReplication()) {
            super.sendAcknowledgement();
        }
    }

    public String toString() {
        return this.getName() + "(" + this.k + ")";
    }

    @Override
    public String getKeyMappingInfo() {
        return this.replicaChoices;
    }

    @Override
    public void onSuccess() {
        if (!this.dsc.isDoASyncReplication()) {
            try {
                super.onSuccess();
                super.waitForAck();
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "** Got exception: " + ex);
            }
        }
    }
}

