/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.TooManyRetriesException;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public abstract class Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private byte opcode;
    protected DataStoreContext<K, V> dsc;
    private CommandManager<K, V> cm;
    private ReplicationOutputStream cachedROS;
    private String commandName;
    protected String targetInstanceName;
    private int retryCount = 0;
    private long retryAfterMillis = 500L;
    private boolean done = true;

    protected Command(byte opcode) {
        this.opcode = opcode;
        this.commandName = this.getClass().getName();
        int index = this.commandName.lastIndexOf(46);
        this.commandName = this.commandName.substring(index + 1);
    }

    public final void initialize(DataStoreContext<K, V> rs) {
        this.dsc = rs;
        this.cm = rs.getCommandManager();
    }

    protected final DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    protected final CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public String getTargetName() {
        return this.targetInstanceName;
    }

    public final byte getOpcode() {
        return this.opcode;
    }

    protected void setTargetName(String val) {
        this.targetInstanceName = val;
    }

    public final boolean isRetried() {
        return this.retryCount > 0;
    }

    public final void prepareTransmit(DataStoreContext<K, V> ctx) throws IOException {
        this.cachedROS = new ReplicationOutputStream();
        this.cachedROS.write(this.getOpcode());
        if (this.computeTarget()) {
            this.writeCommandPayload(this.cachedROS);
        } else {
            _logger.log(Level.WARNING, "Aborting command transmission for " + this.getName() + " because computeTarget returned false");
        }
    }

    public final void write(ReplicationOutputStream globalROS) throws IOException {
        try {
            byte[] data = this.cachedROS.toByteArray();
            globalROS.write(data);
            globalROS.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final void prepareToExecute(ReplicationInputStream ris) throws IOException, DataStoreException {
        ris.read();
        this.readCommandPayload(ris);
    }

    protected void selectReplicaInstance(K key) {
        this.targetInstanceName = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), key);
    }

    public String getKeyMappingInfo() {
        return this.targetInstanceName == null ? "" : this.targetInstanceName;
    }

    public final String getName() {
        return this.commandName + ":" + this.opcode;
    }

    public boolean computeTarget() {
        return true;
    }

    protected final void reExecute() throws DataStoreException {
        if (this.retryCount++ >= 3) {
            throw new DataStoreException("Too many retries...");
        }
        this.dsc.getCommandManager().reExecute(this);
    }

    public void onSuccess() {
        ++this.retryCount;
        this.done = true;
    }

    public void onError(Throwable th) throws DataStoreException {
        if (this.retryCount++ < 4 && !this.done) {
            try {
                Thread.sleep((long)this.retryCount * this.retryAfterMillis);
            }
            catch (Exception ex) {
                // empty catch block
            }
        } else {
            String message = this.getName() + " giving up after " + this.retryCount + " retries...";
            _logger.log(Level.WARNING, message);
            throw new TooManyRetriesException(message);
        }
        this.dsc.getCommandManager().reExecute(this);
    }

    protected abstract void writeCommandPayload(ReplicationOutputStream var1) throws IOException;

    protected abstract void readCommandPayload(ReplicationInputStream var1) throws IOException;

    protected abstract Command<K, V> createNewInstance();

    public abstract void execute(String var1) throws DataStoreException;
}

