/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.IdleEntryDetector;

public class ReplicaStore<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command");
    private DataStoreContext<K, V> ctx;
    private ConcurrentHashMap<K, DataStoreEntry<K, V>> map = new ConcurrentHashMap();
    private AtomicInteger replicaEntries = new AtomicInteger(0);
    private IdleEntryDetector<K, V> idleEntryDetector;

    public ReplicaStore(DataStoreContext<K, V> ctx) {
        this.ctx = ctx;
    }

    public void setIdleEntryDetector(IdleEntryDetector<K, V> idleEntryDetector) {
        this.idleEntryDetector = idleEntryDetector;
    }

    public DataStoreEntry<K, V> getEntry(K k) {
        return this.map.get(k);
    }

    public DataStoreEntry<K, V> getOrCreateEntry(K k) {
        DataStoreEntry<K, V> entry = this.map.get(k);
        if (entry == null) {
            entry = new DataStoreEntry();
            entry.setKey(k);
            DataStoreEntry<K, V> tEntry = this.map.putIfAbsent(k, entry);
            if (tEntry != null) {
                entry = tEntry;
            } else {
                this.replicaEntries.incrementAndGet();
            }
        }
        return entry;
    }

    public V getV(K k) throws DataStoreException {
        DataStoreEntry<K, V> dse = this.map.get(k);
        return dse == null ? null : (V)this.ctx.getDataStoreEntryHelper().getV(dse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K k) {
        DataStoreEntry<K, V> dse = this.map.remove(k);
        if (dse != null) {
            DataStoreEntry<K, V> dataStoreEntry = dse;
            synchronized (dataStoreEntry) {
                dse.markAsRemoved("Removed");
            }
            this.replicaEntries.decrementAndGet();
        }
    }

    public int size() {
        return this.replicaEntries.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeExpired() {
        int result = 0;
        if (this.idleEntryDetector != null) {
            long now = System.currentTimeMillis();
            Iterator<DataStoreEntry<K, V>> iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                DataStoreEntry<K, V> entry;
                DataStoreEntry<K, V> dataStoreEntry = entry = iterator.next();
                synchronized (dataStoreEntry) {
                    if (this.idleEntryDetector.isIdle(entry, now)) {
                        entry.markAsRemoved("Idle");
                        _logger.log(Level.WARNING, "ReplicaStore removing (idle) key: " + entry.getKey());
                        iterator.remove();
                        ++result;
                    }
                }
            }
        }
        return result;
    }

    public Collection<K> keys() {
        return this.map.keySet();
    }

    public Collection<DataStoreEntry<K, V>> values() {
        return this.map.values();
    }
}

