/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.BroadcastLoadRequestCommand;
import org.shoal.adapter.store.commands.LoadRequestCommand;
import org.shoal.adapter.store.commands.RemoveCommand;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.adapter.store.commands.SizeRequestCommand;
import org.shoal.adapter.store.commands.StaleCopyRemoveCommand;
import org.shoal.adapter.store.commands.TouchCommand;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationCommandTransmitterManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.DefaultKeyMapper;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicatedDataStore<K, V extends Serializable>
implements DataStore<K, V> {
    private static final int MAX_REPLICA_TRIES = 2;
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.config");
    private String storeName;
    private String instanceName;
    private String groupName;
    private GroupService gs;
    private CommandManager<K, V> cm;
    private DataStoreEntryHelper<K, V> transformer;
    private DataStoreContext<K, V> dsc;
    private DataStoreConfigurator<K, V> conf;
    private ReplicaStore<K, V> replicaStore;
    private AtomicInteger broadcastLoadRequestCount = new AtomicInteger(0);
    private AtomicInteger simpleBroadcastCount = new AtomicInteger(0);
    private AtomicInteger foundLocallyCount = new AtomicInteger(0);
    private long defaultIdleTimeoutInMillis;

    public ReplicatedDataStore(DataStoreConfigurator<K, V> conf, GroupService gs) {
        this.conf = conf;
        this.storeName = conf.getStoreName();
        this.gs = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.initialize(conf);
    }

    private void initialize(DataStoreConfigurator<K, V> conf) {
        this.dsc = new DataStoreContext(this.storeName, this.gs, conf.getClassLoader());
        this.transformer = conf.getDataStoreEntryHelper();
        this.dsc.setDataStoreEntryHelper(this.transformer);
        this.dsc.setDataStoreKeyHelper(conf.getDataStoreKeyHelper());
        this.dsc.setKeyMapper(conf.getKeyMapper());
        this.cm = this.dsc.getCommandManager();
        if (conf.getCommands() != null) {
            for (Command<K, V> cmd : conf.getCommands()) {
                this.cm.registerCommand(cmd);
            }
        }
        this.cm.registerExecutionInterceptor(new ReplicationCommandTransmitterManager());
        this.cm.registerCommand(new ReplicationFramePayloadCommand());
        _logger.log(Level.INFO, "ASync replication enabled...");
        KeyMapper keyMapper = conf.getKeyMapper();
        if (keyMapper != null && keyMapper instanceof DefaultKeyMapper) {
            this.gs.registerGroupMemberEventListener((DefaultKeyMapper)keyMapper);
        }
        this.gs.registerGroupMessageReceiver(this.storeName, this.cm);
        this.replicaStore = this.dsc.getReplicaStore();
        this.replicaStore.setIdleEntryDetector(conf.getIdleEntryDetector());
        Logger logger = Logger.getLogger("org.shoal.ha.cache.config");
        logger.log(Level.INFO, "Created ReplicatedDataStore with config: " + conf);
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(K k, V v) throws DataStoreException {
        DataStoreEntry<K, V> entry;
        String result = null;
        DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(k);
        synchronized (dataStoreEntry) {
            if (!entry.isRemoved()) {
                entry.setLastAccessedAt(System.currentTimeMillis());
                SaveCommand<K, V> cmd = new SaveCommand<K, V>(k, v);
                this.cm.execute(cmd);
                if (this.conf.isCacheLocally()) {
                    entry.setV(v);
                }
                String staleLocation = entry.setReplicaInstanceName(cmd.getTargetName());
                result = cmd.getKeyMappingInfo();
                if (staleLocation != null) {
                    StaleCopyRemoveCommand staleCmd = new StaleCopyRemoveCommand();
                    staleCmd.setKey(k);
                    staleCmd.setStaleTargetName(staleLocation);
                    this.cm.execute(staleCmd);
                }
            } else {
                _logger.log(Level.WARNING, "ReplicatedDataStore.put(" + k + ") AFTER remove?");
                return "";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws DataStoreException {
        Serializable v = null;
        DataStoreEntry<K, Serializable> entry = this.replicaStore.getEntry(key);
        if (entry != null) {
            if (!entry.isRemoved()) {
                v = (Serializable)entry.getV();
                if (v != null) {
                    this.foundLocallyCount.incrementAndGet();
                }
            } else {
                return null;
            }
        }
        if (v == null) {
            KeyMapper keyMapper = this.dsc.getKeyMapper();
            String replicachoices = keyMapper.getReplicaChoices(this.dsc.getGroupName(), key);
            String[] replicaHint = replicachoices.split(":");
            _logger.log(Level.INFO, "ReplicatedDataStore.load(" + key + "); ReplicaChoices: " + replicachoices);
            String respondingInstance = null;
            for (int replicaIndex = 0; replicaIndex < replicaHint.length && replicaIndex < 2; ++replicaIndex) {
                String target = replicaHint[replicaIndex];
                if (target == null || target.trim().length() == 0) continue;
                this.simpleBroadcastCount.incrementAndGet();
                LoadRequestCommand command = new LoadRequestCommand(key, target);
                _logger.log(Level.FINE, "ReplicatedDataStore: For Key=" + key + "; Trying to load from Replica[" + replicaIndex + "]: " + replicaHint[replicaIndex]);
                this.cm.execute(command);
                v = (Serializable)command.getResult(3L, TimeUnit.SECONDS);
                if (v == null) continue;
                respondingInstance = command.getRespondingInstanceName();
                break;
            }
            if (v == null) {
                this.broadcastLoadRequestCount.incrementAndGet();
                BroadcastLoadRequestCommand command = new BroadcastLoadRequestCommand(key);
                _logger.log(Level.WARNING, "ReplicatedDataStore: For Key=" + key + "; Performing load using broadcast ");
                this.cm.execute(command);
                v = (Serializable)command.getResult(3L, TimeUnit.SECONDS);
                if (v != null) {
                    respondingInstance = command.getRespondingInstanceName();
                }
            }
            if (v != null && (entry = this.replicaStore.getEntry(key)) != null) {
                DataStoreEntry<K, Serializable> dataStoreEntry = entry;
                synchronized (dataStoreEntry) {
                    if (!entry.isRemoved()) {
                        if (this.conf.isCacheLocally()) {
                            entry.setV(v);
                        }
                        entry.setLastAccessedAt(System.currentTimeMillis());
                        entry.setReplicaInstanceName(respondingInstance);
                        _logger.log(Level.INFO, "ReplicatedDataStore: For Key=" + key + "; Successfully loaded data from " + respondingInstance);
                    } else {
                        _logger.log(Level.INFO, "ReplicatedDataStore: For Key=" + key + "; Got data from " + respondingInstance + ", but another concurrent thread removed the entry");
                    }
                }
            }
        }
        return (V)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K k) throws DataStoreException {
        String[] targets;
        DataStoreEntry<K, V> entry = this.replicaStore.getEntry(k);
        if (entry != null) {
            DataStoreEntry<K, V> dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
                entry.markAsRemoved("Removed by ReplicatedDataStore.remove");
            }
        }
        if ((targets = this.dsc.getKeyMapper().getCurrentMembers()) != null) {
            for (String target : targets) {
                RemoveCommand cmd = new RemoveCommand();
                cmd.setKey(k);
                cmd.setTarget(target);
                this.cm.execute(cmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String touch(K k, long version, long ts, long ttl) throws DataStoreException {
        String location = "";
        DataStoreEntry<K, V> entry = this.replicaStore.getEntry(k);
        if (entry != null) {
            DataStoreEntry<K, V> dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
                long now = System.currentTimeMillis();
                entry.setLastAccessedAt(now);
                String target = entry.getReplicaInstanceName();
                TouchCommand cmd = new TouchCommand(k, version, now, this.defaultIdleTimeoutInMillis);
                this.cm.execute(cmd);
                location = cmd.getKeyMappingInfo();
            }
        }
        return location;
    }

    @Override
    public int removeIdleEntries(long idleFor) {
        return this.replicaStore.removeExpired();
    }

    @Override
    public void close() {
    }

    @Override
    public int size() {
        int i;
        int result = 0;
        KeyMapper km = this.dsc.getKeyMapper();
        String[] targets = km.getCurrentMembers();
        int targetCount = targets.length;
        SizeRequestCommand[] commands = new SizeRequestCommand[targetCount];
        for (i = 0; i < targetCount; ++i) {
            commands[i] = new SizeRequestCommand(targets[i]);
            try {
                this.dsc.getCommandManager().execute(commands[i]);
                continue;
            }
            catch (DataStoreException dse) {
                // empty catch block
            }
        }
        for (i = 0; i < targetCount; ++i) {
            result += commands[i].getResult();
        }
        return result;
    }
}

