/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolChain;
import com.sun.grizzly.config.dom.ProtocolChainInstanceHandler;
import com.sun.grizzly.config.dom.ProtocolFilter;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-protocol-filter")
@Scoped(value=PerLookup.class)
@I18n(value="create.protocol.filter")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateProtocolFilter
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateProtocolFilter.class);
    @Param(name="name", primary=true)
    String name;
    @Param(name="protocol", optional=false)
    String protocolName;
    @Param(name="classname", optional=false)
    String classname;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    private ActionReport report;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        this.report = context.getActionReport();
        try {
            Protocols protocols = this.config.getNetworkConfig().getProtocols();
            Protocol protocol = protocols.findProtocol(this.protocolName);
            this.validate((ConfigBeanProxy)protocol, "create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", this.protocolName);
            Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
            if (!com.sun.grizzly.ProtocolFilter.class.isAssignableFrom(filterClass)) {
                this.report.setMessage(localStrings.getLocalString("create.portunif.fail.notfilter", "{0} create failed.  Given class is not a ProtocolFilter: {1}", new Object[]{this.name, this.classname}));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ProtocolChainInstanceHandler handler = this.getHandler(protocol);
            ProtocolChain chain = this.getChain(handler);
            ConfigSupport.apply(new SingleConfigCode<ProtocolChain>(){

                @Override
                public Object run(ProtocolChain param) throws PropertyVetoException, TransactionFailure {
                    List list = param.getProtocolFilter();
                    for (ProtocolFilter filter : list) {
                        if (!CreateProtocolFilter.this.name.equals(filter.getName())) continue;
                        throw new TransactionFailure(String.format("A protocol filter named %s already exists.", CreateProtocolFilter.this.name));
                    }
                    ProtocolFilter filter = (ProtocolFilter)param.createChild(ProtocolFilter.class);
                    filter.setName(CreateProtocolFilter.this.name);
                    filter.setClassname(CreateProtocolFilter.this.classname);
                    list.add(filter);
                    return null;
                }
            }, chain);
        }
        catch (ValidationFailureException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.setMessage(localStrings.getLocalString("create.portunif.fail", "{0} create failed: {1}", new Object[]{this.name, e.getMessage() == null ? "No reason given" : e.getMessage()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
            return;
        }
    }

    private ProtocolChain getChain(ProtocolChainInstanceHandler handler) throws TransactionFailure {
        ProtocolChain chain = handler.getProtocolChain();
        if (chain == null) {
            chain = (ProtocolChain)ConfigSupport.apply(new SingleConfigCode<ProtocolChainInstanceHandler>(){

                @Override
                public Object run(ProtocolChainInstanceHandler param) throws PropertyVetoException, TransactionFailure {
                    ProtocolChain protocolChain = (ProtocolChain)param.createChild(ProtocolChain.class);
                    param.setProtocolChain(protocolChain);
                    return protocolChain;
                }
            }, handler);
        }
        return chain;
    }

    private ProtocolChainInstanceHandler getHandler(Protocol protocol) throws TransactionFailure {
        ProtocolChainInstanceHandler handler = protocol.getProtocolChainInstanceHandler();
        if (handler == null) {
            handler = (ProtocolChainInstanceHandler)ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws PropertyVetoException, TransactionFailure {
                    ProtocolChainInstanceHandler child = (ProtocolChainInstanceHandler)param.createChild(ProtocolChainInstanceHandler.class);
                    param.setProtocolChainInstanceHandler(child);
                    return child;
                }
            }, protocol);
        }
        return handler;
    }

    private void validate(ConfigBeanProxy check, String key, String defaultFormat, String ... arguments) throws ValidationFailureException {
        if (check == null) {
            this.report.setMessage(localStrings.getLocalString(key, defaultFormat, (Object[])arguments));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new ValidationFailureException();
        }
    }

    private class ValidationFailureException
    extends Exception {
        private ValidationFailureException() {
        }
    }
}

