/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.jboss.weld.bean.proxy.util.SerializableProxy;
import org.jboss.weld.serialization.spi.ProxyServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServicesImpl
implements ProxyServices {
    public ClassLoader getClassLoader(final Class<?> type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this._getClassLoader(type);
                }
            });
        }
        return this._getClassLoader(type);
    }

    private ClassLoader _getClassLoader(Class<?> type) {
        return Thread.currentThread().getContextClassLoader();
    }

    public ProtectionDomain getProtectionDomain(Class<?> type) {
        if (type.getName().startsWith("java")) {
            return this.getClass().getProtectionDomain();
        }
        return type.getProtectionDomain();
    }

    public void cleanup() {
    }

    public Object wrapForSerialization(Object proxyObject) {
        return new SerializableProxy(proxyObject);
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(className, true, cl);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
            throw new RuntimeException(pae);
        }
    }
}

