/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Recorder
implements InhabitantListener {
    private final int runLevel;
    final List<Inhabitant<?>> activations;
    private final Class<?> targetEnv;

    Recorder(int runLevel, Class<?> targetEnv) {
        this(new ArrayList(), runLevel, targetEnv);
    }

    Recorder(List<Inhabitant<?>> list, int runLevel) {
        this(new ArrayList(), runLevel, Void.class);
    }

    Recorder(List<Inhabitant<?>> list, int runLevel, Class<?> targetEnv) {
        this.activations = list;
        this.runLevel = runLevel;
        this.targetEnv = targetEnv;
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    List<Inhabitant<?>> getActivations() {
        return Collections.unmodifiableList(this.activations);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getRunLevel() + ", " + this.activations + ")";
    }

    @Override
    public synchronized boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.EventType.INHABITANT_ACTIVATED == eventType) {
            assert (inhabitant.isInstantiated());
            assert (AbstractInhabitantImpl.class.isInstance(inhabitant));
            RunLevel rl = ((AbstractInhabitantImpl)inhabitant).getAnnotation(RunLevel.class);
            if (null != rl && (null == rl.environment() || this.targetEnv == rl.environment())) {
                this.activations.add(inhabitant);
                if (rl.value() > this.runLevel) {
                    throw new ComponentException("Invalid RunLevel dependency to: " + inhabitant);
                }
            }
        }
        return true;
    }
}

