/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.monitor;

import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="deployment-mon", group="monitoring")
@ManagedObject
@Description(value="Deployment Module Statistics")
public class DeploymentLifecycleStatsProvider {
    private static final Logger logger = LogDomains.getLogger(DeploymentLifecycleStatsProvider.class, (String)"javax.enterprise.system.tools.deployment");
    private static final String ACTIVE_APPLICATIONS_DEPLOYED_DESCRIPTION = "Number of applications deployed";
    private static final String TOTAL_APPLICATIONS_DEPLOYED_DESCRIPTION = "Total number of applications ever deployed";
    private static final String APPLICATIONS_INFORMATION_DESCRIPTION = "Information about deployed applications";
    private static final String MODULE_TYPE = "moduleType";
    private static final String LOADING_TIME = "loadingTime";
    private static final int COLUMN_LENGTH = 25;
    private static final String LINE_BREAK = "%%%EOL%%%";
    private RangeStatisticImpl activeApplicationsDeployedCount;
    private CountStatisticImpl totalApplicationsDeployedCount;
    private StringStatisticImpl appsInfoStat = new StringStatisticImpl("ApplicationsInformation", "List", "Information about deployed applications");
    private Map<String, Map<String, String>> appsInfoMap = new HashMap<String, Map<String, String>>();

    public DeploymentLifecycleStatsProvider() {
        long curTime = System.currentTimeMillis();
        this.activeApplicationsDeployedCount = new RangeStatisticImpl(0L, 0L, 0L, "ActiveApplicationsDeployed", "count", ACTIVE_APPLICATIONS_DEPLOYED_DESCRIPTION, curTime, curTime);
        this.totalApplicationsDeployedCount = new CountStatisticImpl("TotalApplicationsDeployed", "count", TOTAL_APPLICATIONS_DEPLOYED_DESCRIPTION);
    }

    @ManagedAttribute(id="activeapplicationsdeployedcount")
    @Description(value="Number of applications deployed")
    public RangeStatistic getActiveApplicationsDeployed() {
        return this.activeApplicationsDeployedCount;
    }

    @ManagedAttribute(id="totalapplicationsdeployedcount")
    @Description(value="Total number of applications ever deployed")
    public CountStatistic getTotalApplicationsDeployed() {
        return this.totalApplicationsDeployedCount;
    }

    @ManagedAttribute(id="applicationsinfo")
    @Description(value="Information about deployed applications")
    public StringStatistic getApplicationsInfo() {
        StringBuffer strBuf = new StringBuffer(1024);
        if (!this.appsInfoMap.isEmpty()) {
            int appNameLength = 25;
            int moduleTypeLength = 25;
            for (String appName : this.appsInfoMap.keySet()) {
                String moduleType;
                if (appName.length() > appNameLength) {
                    appNameLength = appName.length() + 1;
                }
                if ((moduleType = this.appsInfoMap.get(appName).get(MODULE_TYPE)).length() <= moduleTypeLength) continue;
                moduleTypeLength = moduleType.length() + 1;
            }
            strBuf.append(LINE_BREAK).append(LINE_BREAK);
            this.appendColumn(strBuf, "Application Name", appNameLength);
            this.appendColumn(strBuf, "Module Type", moduleTypeLength);
            this.appendColumn(strBuf, "Loading Time (ms)", 25);
            strBuf.append(LINE_BREAK);
            for (String appName : this.appsInfoMap.keySet()) {
                this.appendColumn(strBuf, appName, appNameLength);
                Map<String, String> appInfoMap = this.appsInfoMap.get(appName);
                String moduleType = appInfoMap.get(MODULE_TYPE);
                String loadingTime = appInfoMap.get(LOADING_TIME);
                this.appendColumn(strBuf, moduleType, 25);
                this.appendColumn(strBuf, loadingTime, 25);
                strBuf.append(LINE_BREAK);
            }
        }
        this.appsInfoStat.setCurrent(strBuf == null ? "" : strBuf.toString());
        return this.appsInfoStat.getStatistic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:deployment:lifecycle:applicationDeployedEvent")
    public void applicationDeployedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="appType") String appType, @ProbeParam(value="loadTime") String loadTime) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Application deployed event received - appName = " + appName + ": appType = " + appType + ": loadTime = " + loadTime);
        }
        HashMap<String, String> appInfoMap = new HashMap<String, String>();
        appInfoMap.put(MODULE_TYPE, appType);
        appInfoMap.put(LOADING_TIME, loadTime);
        this.appsInfoMap.put(appName, appInfoMap);
        RangeStatisticImpl rangeStatisticImpl = this.activeApplicationsDeployedCount;
        synchronized (rangeStatisticImpl) {
            this.activeApplicationsDeployedCount.setCurrent(this.activeApplicationsDeployedCount.getCurrent() + 1L);
        }
        this.totalApplicationsDeployedCount.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:deployment:lifecycle:applicationUndeployedEvent")
    public void applicationUndeployedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="appType") String appType) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Application undeployed event received - appName = " + appName + ": appType = " + appType);
        }
        this.appsInfoMap.remove(appName);
        RangeStatisticImpl rangeStatisticImpl = this.activeApplicationsDeployedCount;
        synchronized (rangeStatisticImpl) {
            this.activeApplicationsDeployedCount.setCurrent(this.activeApplicationsDeployedCount.getCurrent() - 1L);
        }
    }

    private void appendColumn(StringBuffer buf, String text, int length) {
        buf.append(text);
        for (int i = text.length(); i < length; ++i) {
            buf.append(" ");
        }
    }
}

