/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.NonSMFServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;

public class LinuxService
extends NonSMFServiceAdapter {
    private String targetName;
    private File target;
    private static final String TEMPLATE_FILE_NAME = "linux-service.template";
    private static final String INITD = "/etc/init.d";
    private static final String UPDATER = "update-rc.d";

    static boolean apropos() {
        return OS.isLinux();
    }

    LinuxService(ServerDirs dirs, AppserverServiceType type) {
        super(dirs, type);
        if (!LinuxService.apropos()) {
            throw new IllegalArgumentException(Strings.get("internal.error", "Constructor called but Linux Services are not available."));
        }
    }

    public final void initializeInternal() {
        try {
            this.getTokenMap().put("SERVICEUSER_START", this.getServiceUserStart());
            this.getTokenMap().put("SERVICEUSER_STOP", this.getServiceUserStop());
            this.setTemplateFile(TEMPLATE_FILE_NAME);
            this.checkWritePermissions();
            this.setTarget();
            this.handlePreExisting(this.info.force);
            ServicesUtils.tokenReplaceTemplateAtDestination(this.getTokenMap(), this.getTemplateFile().getPath(), this.target.getPath());
            this.trace("Target file written: " + this.target);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void createServiceInternal() {
        try {
            this.trace("**********   Object Dump  **********\n" + this.toString());
            if (this.uninstall() == 0 && !this.info.dryRun) {
                System.out.println(Strings.get("linux.services.uninstall.good"));
            } else {
                this.trace("No preexisting Service with that name was found");
            }
            this.install();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String getSuccessMessage() {
        if (this.info.dryRun) {
            return Strings.get("dryrun");
        }
        return Strings.get("LinuxServiceCreated", this.info.serviceName, this.info.type.toString(), this.target, this.getFinalUser(), this.target.getName());
    }

    public final void writeReadmeFile(String msg) {
        File f = new File(this.getServerDirs().getServerDir(), "PlatformServices.log");
        ServicesUtils.appendTextToFile(f, msg);
    }

    public final String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    public final String getLocationArgsStart() {
        if (this.isDomain()) {
            return " --domaindir " + this.getServerDirs().getServerParentDir().getPath() + " ";
        }
        return " --nodedir " + this.getServerDirs().getServerGrandParentDir().getPath() + " --node " + this.getServerDirs().getServerParentDir().getName() + " ";
    }

    public final String getLocationArgsStop() {
        return this.getLocationArgsStart();
    }

    private void checkWritePermissions() {
        File initd = new File(INITD);
        if (!initd.isDirectory()) {
            throw new RuntimeException(Strings.get("no_initd", INITD));
        }
        if (!initd.canWrite()) {
            throw new RuntimeException(Strings.get("no_write_initd", INITD));
        }
    }

    private void setTarget() {
        this.targetName = "GlassFish_" + this.info.serverDirs.getServerName();
        this.target = new File("/etc/init.d/" + this.targetName);
    }

    private void handlePreExisting(boolean force) {
        if (this.target.isFile()) {
            if (force) {
                this.target.delete();
                this.handlePreExisting(false);
            } else {
                throw new RuntimeException(Strings.get("services.alreadyCreated", this.target, "rm"));
            }
        }
    }

    private String getServiceUserStart() {
        String u = this.getFinalUserButNotRoot();
        if (u != null) {
            return "su --login " + u + " --command \"";
        }
        return "";
    }

    private String getServiceUserStop() {
        if (StringUtils.ok((String)this.info.serviceUser)) {
            return "\"";
        }
        return "";
    }

    private int install() throws ProcessManagerException {
        if (this.info.dryRun) {
            return 0;
        }
        this.target.setExecutable(true, false);
        ProcessManager mgr = new ProcessManager(this.getInstallCommand());
        mgr.execute();
        this.trace("Uninstall STDERR: " + mgr.getStderr());
        this.trace("Uninstall STDOUT: " + mgr.getStdout());
        return mgr.getExitValue();
    }

    private int uninstall() throws ProcessManagerException {
        if (this.info.dryRun) {
            return 0;
        }
        ProcessManager mgr = new ProcessManager(this.getUninstallCommand());
        mgr.execute();
        this.trace("Uninstall STDERR: " + mgr.getStderr());
        this.trace("Uninstall STDOUT: " + mgr.getStdout());
        return mgr.getExitValue();
    }

    private String[] getInstallCommand() {
        String[] cmds = new String[]{UPDATER, this.target.getName(), "defaults"};
        return cmds;
    }

    private String[] getUninstallCommand() {
        String[] cmds = new String[]{UPDATER, this.target.getName(), "remove"};
        return cmds;
    }

    private String getFinalUser() {
        if (StringUtils.ok((String)this.info.serviceUser)) {
            return this.info.serviceUser;
        }
        return this.info.osUser;
    }

    private String getFinalUserButNotRoot() {
        String u = this.getFinalUser();
        if ("root".equals(u)) {
            return null;
        }
        return u;
    }
}

