/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-application-refs")
@I18n(value="list.application.refs")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class ListApplicationRefsCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListApplicationRefsCommand.class);
    @Param(primary=true, optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false", name="long", shortName="l")
    public Boolean long_opt = false;
    @Param(optional=true, defaultValue="false", shortName="t")
    public Boolean terse = false;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        for (ApplicationRef ref : this.domain.getApplicationRefsInTarget(this.target)) {
            ActionReport.MessagePart childPart = part.addChild();
            String message = ref.getRef();
            if (this.long_opt.booleanValue()) {
                message = message + this.getLongStatus(ref);
            }
            childPart.setMessage(message);
            ++numOfApplications;
        }
        if (numOfApplications == 0 && !this.terse.booleanValue()) {
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String getLongStatus(ApplicationRef ref) {
        String message = "";
        if (DeploymentUtils.isDomainTarget((String)this.target)) {
            return message;
        }
        boolean isVersionEnabled = this.domain.isAppRefEnabledInTarget(ref.getRef(), this.target);
        message = isVersionEnabled ? localStrings.getLocalString("list.applications.verbose.enabled", "(enabled)") : localStrings.getLocalString("list.applications.verbose.disabled", "(disabled)");
        return message;
    }
}

