/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AbstractAsyncQueueWriter;
import com.sun.grizzly.async.OperationResult;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;

public class UDPAsyncQueueWriter
extends AbstractAsyncQueueWriter {
    public UDPAsyncQueueWriter(SelectorHandler selectorHandler) {
        super(selectorHandler);
    }

    protected OperationResult doWrite(WritableByteChannel channel, SocketAddress dstAddress, ByteBuffer byteBuffer, OperationResult dstResult) throws IOException {
        int written = 0;
        int lastWriteBytes = -1;
        try {
            do {
                if ((lastWriteBytes = dstAddress != null ? ((DatagramChannel)channel).send(byteBuffer, dstAddress) : channel.write(byteBuffer)) <= 0) continue;
                written += lastWriteBytes;
            } while (lastWriteBytes > 0 && byteBuffer.hasRemaining());
        }
        catch (IOException ex) {
            lastWriteBytes = -1;
            throw ex;
        }
        finally {
            SelectionKeyHandler skh;
            if (lastWriteBytes == -1 && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((BaseSelectionKeyHandler)skh).notifyRemotlyClose(this.selectorHandler.keyFor((SelectableChannel)((Object)channel)));
            }
        }
        dstResult.bytesProcessed = written;
        return dstResult;
    }
}

