/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.enterprise.naming.impl.GroupInfoServiceObserverImpl;
import com.sun.enterprise.naming.impl.RoundRobinPolicy;
import com.sun.enterprise.naming.impl.SerialContext;
import com.sun.enterprise.naming.impl.WrappedSerialContext;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ORBLocator;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialInitContextFactory
implements InitialContextFactory {
    public static final String LOAD_BALANCING_PROPERTY = "com.sun.appserv.iiop.loadbalancingpolicy";
    public static final String IIOP_ENDPOINTS_PROPERTY = "com.sun.appserv.iiop.endpoints";
    public static final String IC_BASED_WEIGHTED = "ic-based-weighted";
    public static final String IC_BASED = "ic-based";
    public static final String IIOP_URL = "iiop:1.2@";
    public static final String CORBALOC = "corbaloc:";
    private static final RoundRobinPolicy rrPolicy;
    private static final boolean useLB;
    private static final AtomicBoolean initialized;
    private static final Hashtable defaultEnv;
    protected static final Logger _logger;
    private static String defaultHost;
    private static String defaultPort;
    private static Habitat defaultHabitat;
    private final Habitat habitat;
    private final GroupInfoServiceObserverImpl giso;
    private GroupInfoService gis = null;

    private static boolean propertyIsSet(String pname) {
        String value = System.getProperty(pname);
        return value != null && !value.isEmpty();
    }

    private static List<String> splitOnComma(String arg) {
        String[] splits;
        ArrayList<String> result = new ArrayList<String>();
        if (arg != null && (splits = arg.split(",")) != null) {
            for (String str : splits) {
                result.add(str.trim());
            }
        }
        return result;
    }

    private static String getEnvSysProperty(Hashtable env, String pname) {
        String value = (String)env.get(pname);
        if (value == null) {
            value = System.getProperty(pname);
        }
        return value;
    }

    private static List<String> getEndpointList() {
        return SerialInitContextFactory.getEndpointList(defaultEnv);
    }

    private static List<String> getEndpointList(Hashtable env) {
        ArrayList<String> list = new ArrayList<String>();
        if (list.isEmpty()) {
            String first;
            String lbpv = System.getProperty(LOAD_BALANCING_PROPERTY);
            List<String> lbList = SerialInitContextFactory.splitOnComma(lbpv);
            if (lbList.size() > 0 && ((first = lbList.remove(0)).equals(IC_BASED) || first.equals(IC_BASED_WEIGHTED))) {
                System.setProperty(LOAD_BALANCING_PROPERTY, first);
            }
            list.addAll(lbList);
        }
        if (list.isEmpty()) {
            String iepv = System.getProperty(IIOP_ENDPOINTS_PROPERTY);
            List<String> epList = SerialInitContextFactory.splitOnComma(iepv);
            list.addAll(epList);
        }
        if (list.isEmpty()) {
            String urlValue = (String)env.get("java.naming.provider.url");
            list.addAll(rrPolicy.getEndpointForProviderURL(urlValue));
        }
        if (list.isEmpty()) {
            String host = SerialInitContextFactory.getEnvSysProperty(env, "org.omg.CORBA.ORBInitialHost");
            String port = SerialInitContextFactory.getEnvSysProperty(env, "org.omg.CORBA.ORBInitialPort");
            if (host != null && port != null) {
                list.addAll(rrPolicy.getAddressPortList(host, port));
                _logger.log(Level.WARNING, "no.endpoints.selected", new Object[]{host, port});
            }
        }
        if (list.isEmpty() && defaultHost != null && defaultPort != null) {
            list.add(defaultHost + ":" + defaultPort);
        }
        if (list.isEmpty()) {
            _logger.log(Level.SEVERE, "no.endpoints");
            throw new RuntimeException("Cannot Proceed. No Endpoints specified.");
        }
        return list;
    }

    private static void doLog(Level level, String fmt, Object ... args) {
        if (_logger.isLoggable(level)) {
            _logger.log(level, fmt, args);
        }
    }

    private static void fineLog(String fmt, Object ... args) {
        SerialInitContextFactory.doLog(Level.FINE, fmt, args);
    }

    public static RoundRobinPolicy getRRPolicy() {
        return rrPolicy;
    }

    static void setDefaultHost(String host) {
        defaultHost = host;
    }

    static void setDefaultPort(String port) {
        defaultPort = port;
    }

    static void setDefaultHabitat(Habitat h) {
        defaultHabitat = h;
    }

    static Habitat getDefaultHabitat() {
        return defaultHabitat;
    }

    private static String getCorbalocURL(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
                sb.append(CORBALOC);
            } else {
                sb.append(',');
            }
            sb.append(IIOP_URL);
            sb.append(str.trim());
        }
        SerialInitContextFactory.fineLog("corbaloc url ==> {0}", sb.toString());
        return sb.toString();
    }

    public SerialInitContextFactory() {
        Habitat habitat = this.habitat = defaultHabitat == null ? Globals.getDefaultHabitat() : defaultHabitat;
        if (useLB) {
            try {
                this.gis = (GroupInfoService)((Object)this.getORB().resolve_initial_references("FolbClientGroupInfoService"));
            }
            catch (InvalidName ex) {
                SerialInitContextFactory.doLog(Level.SEVERE, "Exception in SerialInitContextFactory constructor {0}", ex);
            }
            this.giso = new GroupInfoServiceObserverImpl(this.gis);
            this.gis.addObserver(this.giso);
            SerialInitContextFactory.fineLog("getGIS: rrPolicy = {0}", rrPolicy);
        } else {
            this.giso = null;
        }
    }

    private ORB getORB() {
        ORBLocator orbLoc;
        Object result = null;
        if (this.habitat != null && (orbLoc = (ORBLocator)this.habitat.getByContract(ORBLocator.class)) != null) {
            return orbLoc.getORB();
        }
        throw new RuntimeException("Could not get ORB");
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        Hashtable myEnv = env == null ? new Hashtable() : env;
        boolean firstToInitialize = initialized.compareAndSet(false, true);
        if (firstToInitialize) {
            if (this.habitat != null) {
                for (NamingObjectsProvider provider : this.habitat.getAllByContract(NamingObjectsProvider.class)) {
                }
            }
            if (useLB) {
                List<String> epList = SerialInitContextFactory.getEndpointList(myEnv);
                if (!epList.isEmpty()) {
                    rrPolicy.setClusterInstanceInfoFromString(epList);
                }
                this.giso.membershipChange();
            }
        }
        if (useLB) {
            Context ctx = SerialContext.getStickyContext();
            if (ctx != null) {
                return ctx;
            }
            List<String> rrList = rrPolicy.getNextRotation();
            SerialInitContextFactory.fineLog("getInitialContext: rrPolicy = {0}", rrPolicy);
            String corbalocURL = SerialInitContextFactory.getCorbalocURL(rrList);
            myEnv.put("com.sun.appserv.ee.iiop.endpointslist", corbalocURL);
            myEnv.put("java.naming.corba.orb", this.getORB());
        } else {
            if (defaultHost != null) {
                myEnv.put("org.omg.CORBA.ORBInitialHost", defaultHost);
            }
            if (defaultPort != null) {
                myEnv.put("org.omg.CORBA.ORBInitialPort", defaultPort);
            }
        }
        return this.createInitialContext(myEnv);
    }

    private Context createInitialContext(Hashtable env) throws NamingException {
        SerialContext serialContext = new SerialContext(env, this.habitat);
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return new WrappedSerialContext(env, serialContext);
        }
        return serialContext;
    }

    static {
        initialized = new AtomicBoolean(false);
        defaultEnv = new Hashtable();
        boolean bl = useLB = SerialInitContextFactory.propertyIsSet(IIOP_ENDPOINTS_PROPERTY) || SerialInitContextFactory.propertyIsSet(LOAD_BALANCING_PROPERTY);
        if (useLB) {
            List<String> list = SerialInitContextFactory.getEndpointList();
            rrPolicy = new RoundRobinPolicy(list);
        } else {
            rrPolicy = null;
        }
        _logger = LogDomains.getLogger(SerialInitContextFactory.class, (String)"javax.enterprise.system.core.naming");
        defaultHost = null;
        defaultPort = null;
        defaultHabitat = null;
    }
}

