/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.Inhabitants;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class InhabitantsParser {
    public final Habitat habitat;
    private final Map<String, Class> replacements = new HashMap<String, Class>();

    public InhabitantsParser(Habitat habitat) {
        this.habitat = habitat;
    }

    public void drop(Class component) {
        this.drop(component.getName());
    }

    public void drop(String fullyQualifiedClassName) {
        this.replace(fullyQualifiedClassName, null);
    }

    public void replace(Class oldComponent, Class newComponent) {
        this.replace(oldComponent.getName(), newComponent);
    }

    public void replace(String oldComponentFullyQualifiedClassName, Class newComponent) {
        this.replacements.put(oldComponentFullyQualifiedClassName, newComponent);
    }

    public void parse(Iterable<InhabitantParser> scanner, Holder<ClassLoader> classLoader) throws IOException {
        if (scanner == null) {
            return;
        }
        for (InhabitantParser inhabitantParser : scanner) {
            if (this.isFilteredInhabitant(inhabitantParser)) continue;
            String typeName = inhabitantParser.getImplName();
            if (this.replacements.containsKey(typeName)) {
                Class target = this.replacements.get(typeName);
                if (target == null) continue;
                inhabitantParser.setImplName(target.getName());
                Inhabitant i = Inhabitants.create(target, this.habitat, inhabitantParser.getMetaData());
                this.add(i, inhabitantParser);
                this.habitat.addIndex(i, typeName, null);
                continue;
            }
            HashSet<String> indicies = new HashSet<String>();
            Iterator<String> iter = inhabitantParser.getIndexes().iterator();
            while (iter.hasNext()) {
                indicies.add(iter.next());
            }
            Inhabitant<?> i = Inhabitants.createInhabitant(this.habitat, classLoader, typeName, inhabitantParser.getMetaData(), null, Collections.unmodifiableSet(indicies));
            this.add(i, inhabitantParser);
        }
    }

    boolean isFilteredInhabitant(InhabitantParser inhabitantParser) {
        return false;
    }

    protected void add(Inhabitant<?> i, InhabitantParser parser) {
        this.habitat.add(i);
        for (String v : parser.getIndexes()) {
            int idx = v.indexOf(58);
            if (idx == -1) {
                this.habitat.addIndex(i, v, null);
                continue;
            }
            String contract = v.substring(0, idx);
            String name = v.substring(idx + 1);
            this.habitat.addIndex(i, contract, name);
        }
    }
}

