/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.Inhabitants;
import com.sun.hk2.component.InjectionResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.tiger_types.Types;

public class InjectInjectionResolver
extends InjectionResolver<Inject> {
    final Habitat habitat;

    public InjectInjectionResolver(Habitat habitat) {
        super(Inject.class);
        this.habitat = habitat;
    }

    @Override
    public boolean isOptional(AnnotatedElement element, Inject annotation) {
        return annotation.optional();
    }

    @Override
    public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Class<V> type) throws ComponentException {
        V result;
        if (type.isArray()) {
            result = this.getArrayInjectValue(this.habitat, component, onBehalfOf, target, type);
        } else {
            Inject inject = target.getAnnotation(Inject.class);
            result = Types.isSubClassOf(type, Holder.class) ? this.getHolderInjectValue(this.habitat, component, onBehalfOf, target, type, inject) : (this.habitat.isContract(type) ? this.getServiceInjectValue(this.habitat, component, onBehalfOf, target, type, inject) : this.getComponentInjectValue(this.habitat, component, onBehalfOf, target, type, inject));
        }
        return this.validate(component, result);
    }

    protected <V> V getArrayInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Class<V> type) {
        Class<?> ct = type.getComponentType();
        Collection<?> instances = habitat.isContract(ct) ? habitat.getAllByContract(ct) : habitat.getAllByType(ct);
        V result = type.cast(instances.toArray((Object[])Array.newInstance(ct, instances.size())));
        return result;
    }

    protected <V> V getHolderInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Class<V> type, Inject inject) throws ComponentException {
        Type t = Types.getTypeArgument(((Field)target).getGenericType(), 0);
        Class finalType = Types.erasure(t);
        if (habitat.isContract(finalType)) {
            return type.cast(habitat.getInhabitants(finalType, inject.name()));
        }
        try {
            if (finalType.cast(component) != null) {
                return type.cast(onBehalfOf);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        V result = type.cast(habitat.getInhabitantByType(finalType));
        return result;
    }

    protected <V> V getServiceInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Class<V> type, Inject inject) throws ComponentException {
        V result = habitat.getComponent(type, inject.name());
        return result;
    }

    protected <V> V getComponentInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Class<V> type, Inject inject) throws ComponentException {
        V result = habitat.getByType(type);
        return result;
    }

    protected <V> V validate(Object component, V toBeInjected) {
        Inhabitants.validate(component, toBeInjected);
        return toBeInjected;
    }
}

