/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.EventPublishingInhabitant;
import com.sun.hk2.component.Holder;
import com.sun.hk2.component.Inhabitants;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;

public class LazyInhabitant<T>
extends EventPublishingInhabitant<T> {
    private final String typeName;
    private final Holder<ClassLoader> classLoader;
    protected final Habitat habitat;
    private final MultiMap<String, String> metadata;
    private final Inhabitant<?> lead;

    public LazyInhabitant(Habitat habitat, Holder<ClassLoader> cl, String typeName, MultiMap<String, String> metadata) {
        this(habitat, cl, typeName, metadata, null);
    }

    public LazyInhabitant(Habitat habitat, Holder<ClassLoader> cl, String typeName, MultiMap<String, String> metadata, Inhabitant<?> lead) {
        assert (metadata != null);
        this.habitat = habitat;
        this.classLoader = cl;
        this.typeName = typeName;
        this.metadata = metadata;
        this.lead = lead;
    }

    @Override
    public Inhabitant<?> lead() {
        return this.lead;
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    @Override
    public Class<T> type() {
        Inhabitant real = this.real;
        if (null != real) {
            return real.type();
        }
        return this.loadClass();
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    @Override
    protected synchronized void fetch() {
        if (null == this.real) {
            Class<T> c = this.loadClass();
            this.real = Inhabitants.wrapByScope(c, this.createWomb(c), this.habitat);
        }
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader.get();
    }

    private Class<T> loadClass() {
        ClassLoader cl = this.getClassLoader();
        try {
            Class<?> c = cl.loadClass(this.typeName);
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new ComponentException("Failed to load " + this.typeName + " from " + cl, e);
        }
    }

    @Override
    public synchronized void release() {
        super.release();
        this.real = null;
    }

    protected Womb<T> createWomb(Class<T> c) {
        return Wombs.create(c, this.habitat, this.metadata);
    }
}

