/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.LazyInhabitant;
import com.sun.hk2.component.RunLevelInhabitant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantActivator;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.InhabitantSorter;
import org.jvnet.hk2.component.RunLevelListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;
import org.jvnet.hk2.component.ServiceContext;
import org.jvnet.hk2.component.internal.runlevel.Recorder;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServiceStub;

public class DefaultRunLevelService
implements RunLevelService<Void>,
RunLevelState<Void>,
InhabitantListener,
HabitatListener,
InhabitantSorter,
InhabitantActivator {
    public static final int INITIAL_RUNLEVEL = -2;
    public static final String NAME = "default";
    static final boolean ASYNC_ENABLED = false;
    private static final Logger logger = Logger.getLogger(DefaultRunLevelService.class.getName());
    private final Object lock = new Object();
    private final boolean asyncMode;
    private final ExecutorService exec;
    protected final String name;
    private final Class<?> targetEnv;
    private final Habitat habitat;
    private RunLevelState<Void> delegate;
    private Integer current;
    private final HashMap<Integer, Recorder> recorders;
    private Worker worker;

    public DefaultRunLevelService(Habitat habitat) {
        this(habitat, false, null, null, new LinkedHashMap<Integer, Recorder>());
    }

    protected DefaultRunLevelService(Habitat habitat, boolean async, String name, Class<?> targetEnv, HashMap<Integer, Recorder> recorders) {
        this.habitat = habitat;
        assert (null != habitat);
        this.asyncMode = async;
        this.exec = this.asyncMode ? Executors.newCachedThreadPool(new ThreadFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(Runnable runnable) {
                RunLevelServiceThread activeThread = new RunLevelServiceThread(runnable);
                Object object = DefaultRunLevelService.this.lock;
                synchronized (object) {
                    logger.log(Level.FINE, "new thread: {0}", activeThread);
                }
                return activeThread;
            }
        }) : null;
        this.name = null == name ? NAME : name;
        this.targetEnv = null == targetEnv ? Void.class : targetEnv;
        this.recorders = recorders;
        habitat.addHabitatListener(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getDescription(false) + ", del: " + this.delegate + ")";
    }

    public String getDescription(boolean extended) {
        StringBuilder b = new StringBuilder();
        b.append("curr=").append(this.getCurrentRunLevel()).append(", ");
        b.append("act=").append(this.getActivatingRunLevel()).append(", ");
        b.append("plan=").append(this.getPlannedRunLevel()).append(", ");
        b.append("env=").append(this.getEnvironment()).append(", ");
        if (extended) {
            b.append("thrd=").append(Thread.currentThread());
        }
        return b.toString();
    }

    private void setDelegate(RunLevelState<Void> stateProvider) {
        assert (this != stateProvider);
        assert (this.getEnvironment() == stateProvider.getEnvironment());
        this.delegate = stateProvider;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public RunLevelState<Void> getState() {
        return null == this.delegate ? this : this.delegate;
    }

    @Override
    public Class getEnvironment() {
        return null == this.delegate ? this.targetEnv : this.delegate.getEnvironment();
    }

    @Override
    public Integer getCurrentRunLevel() {
        return null == this.delegate ? this.current : this.delegate.getCurrentRunLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getPlannedRunLevel() {
        if (null == this.delegate) {
            Object object = this.lock;
            synchronized (object) {
                return null == this.worker ? null : this.worker.getPlannedRunLevel();
            }
        }
        return this.delegate.getPlannedRunLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getActivatingRunLevel() {
        Object object = this.lock;
        synchronized (object) {
            return null == this.worker ? null : this.worker.getActivatingRunLevel();
        }
    }

    protected boolean accept(Inhabitant<?> i, RunLevel rl, int activeRunLevel) {
        return rl.value() == activeRunLevel && rl.environment() == this.targetEnv;
    }

    private void checkBinding(RunLevelInhabitant<?, ?> rli) {
        RunLevelState<?> state = rli.getState();
        if (state != this && RunLevelServiceStub.class.isInstance(state)) {
            RunLevelService delegate = ((RunLevelServiceStub)state).getDelegate();
            if (null != delegate) {
                assert (this == delegate);
            } else {
                ((RunLevelServiceStub)state).activate(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCancelled(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            return this.worker != worker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCancelled(worker)) {
                this.worker = null;
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrent(Worker worker, Integer current) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCancelled(worker)) {
                return;
            }
            this.current = current;
        }
        this.event(worker, ListenerEvent.PROGRESS, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> getRecordersToRelease(HashMap<Integer, Recorder> list, int runLevel) {
        ArrayList<Integer> qualifying = new ArrayList<Integer>();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<Integer, Recorder> entry : this.recorders.entrySet()) {
                int entryKey = entry.getKey();
                if (entryKey < runLevel) continue;
                qualifying.add(entry.getKey());
            }
        }
        Collections.sort(qualifying);
        Collections.reverse(qualifying);
        return qualifying;
    }

    protected void event(Worker worker, ListenerEvent event, ServiceContext context, Throwable error) {
        this.event(worker, event, context, error, false);
    }

    protected void event(Worker worker, ListenerEvent event, ServiceContext context, Throwable error, boolean isHardInterrupt) {
        logger.log(Level.FINE, "event {0} - " + this.getDescription(true), (Object)event);
        if (this.isCancelled(worker)) {
            logger.log(Level.FINE, "Ignoring this notification!");
        } else {
            Interrupt lastInterrupt = null;
            Collection<RunLevelListener> activeListeners = this.habitat.getAllByContract(RunLevelListener.class);
            for (RunLevelListener listener : activeListeners) {
                try {
                    if (ListenerEvent.PROGRESS == event) {
                        listener.onProgress(this);
                        continue;
                    }
                    if (ListenerEvent.CANCEL == event) {
                        listener.onCancelled(this, context, this.current, isHardInterrupt);
                        continue;
                    }
                    listener.onError(this, context, error, true);
                }
                catch (Interrupt interrupt) {
                    lastInterrupt = interrupt;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "swallowing exception - " + this.getDescription(true), new ComponentException(e));
                }
            }
            if (null != lastInterrupt) {
                throw lastInterrupt;
            }
            if (null != error) {
                logger.log(Level.FINE, "swallowing exception - " + context, new ComponentException(error));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        Integer activeRunLevel;
        if (InhabitantListener.class.isInstance(this.delegate)) {
            return ((InhabitantListener)InhabitantListener.class.cast(this.delegate)).inhabitantChanged(eventType, inhabitant);
        }
        AbstractInhabitantImpl ai = (AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(inhabitant);
        RunLevel rl = ai.getAnnotation(RunLevel.class);
        Integer n = activeRunLevel = null == rl ? null : Integer.valueOf(rl.value());
        if (null != activeRunLevel && InhabitantListener.EventType.INHABITANT_ACTIVATED == eventType) {
            Recorder activeRecorder;
            Object object = this.lock;
            synchronized (object) {
                activeRecorder = this.recorders.get(activeRunLevel);
                if (null == activeRecorder) {
                    activeRecorder = new Recorder(activeRunLevel, this.getEnvironment());
                    this.recorders.put(activeRunLevel, activeRecorder);
                }
            }
            if (null != activeRecorder) {
                activeRecorder.inhabitantChanged(eventType, inhabitant);
            }
        }
        return true;
    }

    @Override
    public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
        if (HabitatListener.EventType.HABITAT_INITIALIZED == eventType) {
            this.proceedTo(-1);
        }
        return !habitat.isInitialized();
    }

    @Override
    public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
        return true;
    }

    @Override
    public void proceedTo(int runLevel) {
        this.proceedTo(runLevel, false);
    }

    @Override
    public void interrupt() {
        this.proceedTo(null, true);
    }

    @Override
    public void interrupt(int runLevel) {
        this.proceedTo(runLevel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedTo(Integer runLevel, boolean isHardInterrupt) {
        if (null != runLevel && runLevel < -1) {
            throw new IllegalArgumentException();
        }
        Worker worker = this.worker;
        if (null != worker && worker.interrupt(isHardInterrupt, runLevel)) {
            return;
        }
        if (null != runLevel) {
            Object object = this.lock;
            synchronized (object) {
                worker = this.asyncMode ? new AsyncProceedToOp(runLevel) : new SyncProceedToOp(runLevel);
                this.worker = worker;
            }
            worker.proceedTo(runLevel);
        }
    }

    @Override
    public List<Inhabitant> sort(List<Inhabitant> inhabitants) {
        return inhabitants;
    }

    @Override
    public void activate(Inhabitant inhabitant) {
        inhabitant.get();
    }

    @Override
    public void deactivate(Inhabitant inhabitant) {
        inhabitant.release();
    }

    protected InhabitantSorter getInhabitantSorter() {
        InhabitantSorter is = this.habitat.getComponent(InhabitantSorter.class, this.getName());
        if (null == is) {
            is = this.habitat.getByContract(InhabitantSorter.class);
        }
        return null == is ? this : is;
    }

    protected InhabitantActivator getInhabitantActivator() {
        InhabitantActivator ia = this.habitat.getComponent(InhabitantActivator.class, this.getName());
        if (null == ia) {
            ia = this.habitat.getByContract(InhabitantActivator.class);
        }
        return null == ia ? this : ia;
    }

    protected ServiceContext serviceContext(Exception e, final Inhabitant<?> i) {
        if (null == i) {
            return null;
        }
        ServiceContext ctx = null;
        if (e instanceof ComponentException) {
            ctx = ((ComponentException)e).getFailureContext();
        }
        if (null == ctx) {
            ctx = new ServiceContext(){

                @Override
                public ClassLoader getClassLoader() {
                    ClassLoader cl = LazyInhabitant.class.isInstance(i) ? ((LazyInhabitant)i).getClassLoader() : i.getClass().getClassLoader();
                    return cl;
                }

                @Override
                public Inhabitant<?> getInhabitant() {
                    return i;
                }

                @Override
                public String getType() {
                    return i.typeName();
                }

                public String toString() {
                    return i.toString();
                }
            };
        }
        return ctx;
    }

    public static class Interrupt
    extends RuntimeException {
        private Interrupt() {
        }
    }

    private static class RunLevelServiceThread
    extends Thread {
        private RunLevelServiceThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.currentTimeMillis());
        }
    }

    private class AsyncProceedToOp
    extends Worker
    implements Runnable {
        private Future<?> activeFuture;

        private AsyncProceedToOp(int runLevel) {
            super(runLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean interrupt(boolean isHard, Integer runLevel) {
            boolean haveFuture;
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                boolean bl = haveFuture = null != this.activeFuture;
                if (haveFuture) {
                    this.activeFuture.cancel(false);
                    this.activeFuture = null;
                }
            }
            if (haveFuture) {
                DefaultRunLevelService.this.event(this, ListenerEvent.CANCEL, null, null, isHard);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                this.activeFuture = null;
                this.isHardInterrupt = null;
            }
        }

        @Override
        public void proceedTo(int runLevel) {
            assert (null == this.activeFuture);
            this.activeFuture = DefaultRunLevelService.this.exec.submit(this);
        }

        @Override
        public void checkInterrupt(Exception e, Inhabitant<?> i, Boolean isHard) {
            if (DefaultRunLevelService.this.isCancelled(this)) {
                throw new Interrupt();
            }
            super.checkInterrupt(e, i, isHard);
        }
    }

    private class SyncProceedToOp
    extends Worker {
        private final Thread activeThread;
        protected Integer nextPlannedAfterInterrupt;
        private boolean cancelIssued;

        private SyncProceedToOp(int runLevel) {
            super(runLevel);
            this.activeThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean interrupt(boolean isHard, Integer runLevel) {
            Thread ourThread = Thread.currentThread();
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                Integer planned = this.getPlannedRunLevel();
                if (!isHard && null != planned && planned == runLevel) {
                    return true;
                }
                this.nextPlannedAfterInterrupt = runLevel;
                if (ourThread == this.activeThread) {
                    this.checkInterrupt(null, null, isHard);
                } else {
                    logger.log(Level.FINE, "Interrupting thread {0} - " + DefaultRunLevelService.this.getDescription(true), this.activeThread);
                    this.isHardInterrupt = isHard;
                    this.activeThread.interrupt();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void proceedTo(int runLevel) {
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                this.planned = runLevel;
                this.nextPlannedAfterInterrupt = null;
                this.cancelIssued = false;
                this.isHardInterrupt = null;
            }
            try {
                this.run();
            }
            catch (Exception e) {
                this.handleInterruptException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkInterrupt(Exception e, Inhabitant<?> i, Boolean isHard) {
            Object object = DefaultRunLevelService.this.lock;
            synchronized (object) {
                boolean cancelled = DefaultRunLevelService.this.isCancelled(this);
                if (cancelled || null != this.nextPlannedAfterInterrupt) {
                    if (!cancelled && this.canUpdateProceedTo(this.nextPlannedAfterInterrupt)) {
                        this.planned = this.nextPlannedAfterInterrupt;
                        this.nextPlannedAfterInterrupt = null;
                    } else {
                        if (!this.cancelIssued) {
                            this.cancelIssued = true;
                            boolean wasHardInterrupt = this.isHardInterrupt(isHard, e);
                            this.isHardInterrupt = null;
                            DefaultRunLevelService.this.event(this, ListenerEvent.CANCEL, DefaultRunLevelService.this.serviceContext(e, i), null, wasHardInterrupt);
                        }
                        throw new Interrupt();
                    }
                }
            }
            super.checkInterrupt(e, i, isHard);
        }

        private boolean canUpdateProceedTo(Integer proposed) {
            if (null != this.upSide) {
                Integer planned = this.getPlannedRunLevel();
                Integer active = this.getActivatingRunLevel();
                if (null != planned && null != active && null != proposed) {
                    if (this.upSide.booleanValue() && proposed > active) {
                        return true;
                    }
                    if (!this.upSide.booleanValue() && proposed < active) {
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleInterruptException(Exception e) {
            logger.log(Level.FINE, "Interrupt caught - " + DefaultRunLevelService.this.getDescription(true), e);
            Thread currentThread = Thread.currentThread();
            Integer next = null;
            if (this.activeThread == currentThread) {
                next = this.nextPlannedAfterInterrupt;
            }
            if (null != next) {
                this.proceedTo(next);
            } else {
                logger.log(Level.FINE, "swallowing exception - " + DefaultRunLevelService.this.getDescription(true), new ComponentException(e));
            }
        }
    }

    private abstract class Worker
    implements Runnable {
        protected volatile Integer planned;
        private Integer activeRunLevel;
        protected Boolean upSide;
        protected Boolean isHardInterrupt;

        protected Worker(int runLevel) {
            this.planned = runLevel;
        }

        public Integer getPlannedRunLevel() {
            return this.planned;
        }

        public Integer getActivatingRunLevel() {
            return this.activeRunLevel;
        }

        public void checkInterrupt(Exception e, Inhabitant<?> i, Boolean isHard) {
            boolean isHardInterrupt = this.isHardInterrupt(isHard, e);
            if (null != e) {
                ServiceContext ctx = DefaultRunLevelService.this.serviceContext(e, i);
                if (isHardInterrupt) {
                    DefaultRunLevelService.this.event(this, ListenerEvent.CANCEL, ctx, e, isHardInterrupt);
                } else {
                    DefaultRunLevelService.this.event(this, ListenerEvent.ERROR, ctx, e, isHardInterrupt);
                }
            }
        }

        public abstract boolean interrupt(boolean var1, Integer var2);

        public abstract void proceedTo(int var1);

        @Override
        public void run() {
            logger.log(Level.FINE, "proceedTo({0}) - " + DefaultRunLevelService.this.getDescription(true), this.planned);
            this.upSide = null;
            if (null != this.planned) {
                int current;
                int n = current = null == DefaultRunLevelService.this.getCurrentRunLevel() ? -2 : DefaultRunLevelService.this.getCurrentRunLevel();
                if (this.planned > current) {
                    this.upSide = true;
                    for (int rl = current + 1; rl <= this.planned; ++rl) {
                        this.upActiveRecorder(rl);
                    }
                } else if (this.planned < current) {
                    this.upSide = false;
                    DefaultRunLevelService.this.setCurrent(this, current);
                    this.down(current);
                } else {
                    this.upSide = false;
                    this.down(current + 1);
                }
            }
            DefaultRunLevelService.this.finished(this);
        }

        private void down(int start) {
            for (int rl = start; rl > this.planned; --rl) {
                this.downActiveRecorder(rl);
            }
        }

        private void upActiveRecorder(int runLevel) {
            this.activeRunLevel = runLevel;
            this.activateRunLevel();
            DefaultRunLevelService.this.setCurrent(this, runLevel);
        }

        private void activateRunLevel() {
            List<Inhabitant> activations = new ArrayList<Inhabitant>();
            Collection<Inhabitant<?>> runLevelInhabitants = DefaultRunLevelService.this.habitat.getAllInhabitantsByContract(RunLevel.class.getName());
            for (Inhabitant<?> i : runLevelInhabitants) {
                RunLevel rl;
                AbstractInhabitantImpl ai = (AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(i);
                if (!DefaultRunLevelService.this.accept(ai, rl = ai.getAnnotation(RunLevel.class), this.activeRunLevel)) continue;
                RunLevelInhabitant rli = (RunLevelInhabitant)RunLevelInhabitant.class.cast(ai);
                DefaultRunLevelService.this.checkBinding(rli);
                activations.add(rli);
            }
            if (!activations.isEmpty()) {
                InhabitantSorter is = DefaultRunLevelService.this.getInhabitantSorter();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "sorting {0}", activations);
                }
                activations = is.sort(activations);
                assert (null != activations);
                InhabitantActivator ia = DefaultRunLevelService.this.getInhabitantActivator();
                for (Inhabitant rli : activations) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "activating {0} - " + DefaultRunLevelService.this.getDescription(true), rli);
                    }
                    try {
                        ia.activate(rli);
                        this.checkInterrupt(null, rli, null);
                    }
                    catch (Exception e) {
                        this.checkInterrupt(e, rli, null);
                    }
                }
            }
        }

        protected void downActiveRecorder(int runLevel) {
            this.activeRunLevel = runLevel;
            this.deactiveRunLevel(runLevel);
            this.activeRunLevel = runLevel - 1;
            DefaultRunLevelService.this.setCurrent(this, this.activeRunLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactiveRunLevel(int runLevel) {
            List<Integer> downRecorders = DefaultRunLevelService.this.getRecordersToRelease(DefaultRunLevelService.this.recorders, runLevel);
            for (int current : downRecorders) {
                Inhabitant<?> i;
                Recorder downRecorder;
                Object object = DefaultRunLevelService.this.lock;
                synchronized (object) {
                    downRecorder = (Recorder)DefaultRunLevelService.this.recorders.get(current);
                }
                if (null == downRecorder) continue;
                InhabitantActivator ia = DefaultRunLevelService.this.getInhabitantActivator();
                while (null != (i = downRecorder.pop())) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "releasing {0} - " + DefaultRunLevelService.this.getDescription(true), i);
                    }
                    try {
                        ia.deactivate(i);
                        this.checkInterrupt(null, i, null);
                    }
                    catch (Exception e) {
                        this.checkInterrupt(e, i, null);
                    }
                }
            }
        }

        protected boolean isHardInterrupt(Boolean isHard, Throwable e) {
            if (null != isHard) {
                return isHard;
            }
            return null == this.isHardInterrupt ? false : this.isHardInterrupt;
        }
    }

    private static enum ListenerEvent {
        PROGRESS,
        CANCEL,
        ERROR;

    }
}

