/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantIntrospectionScanner;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.IntrospectionScanner;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatFactory;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantsParserFactory;

public class Hk2TestServices {
    private Habitat habitat;
    private final HabitatFactory habitatFactory;
    private final InhabitantsParserFactory ipFactory;
    private final Logger logger = Logger.getLogger(Hk2TestServices.class.getName());

    public Hk2TestServices() {
        this(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hk2TestServices(Class<? extends HabitatFactory> habitatFactoryClass, Class<? extends InhabitantsParserFactory> ipFactoryClass) {
        if (null == habitatFactoryClass || habitatFactoryClass.isInterface()) {
            this.habitatFactory = null;
        } else {
            try {
                this.habitatFactory = habitatFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == ipFactoryClass || ipFactoryClass.isInterface()) {
            this.ipFactory = null;
        } else {
            try {
                this.ipFactory = ipFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.logger.log(Level.FINER, "Singleton created");
        String classPath = System.getProperty("surefire.test.class.path");
        if (classPath == null) {
            classPath = System.getProperty("java.class.path");
        }
        this.logger.log(Level.FINER, "classpath is {0}", classPath);
        ParsingContext.Builder builder = new ParsingContext.Builder();
        final HashSet<String> annotations = new HashSet<String>();
        annotations.add("org.jvnet.hk2.annotations.Contract");
        annotations.add("org.jvnet.hk2.annotations.Service");
        annotations.add("org.jvnet.hk2.config.Configured");
        builder.config(new ParsingConfig(){
            final Set<String> empty = Collections.emptySet();

            @Override
            public Set<String> getInjectionTargetAnnotations() {
                return this.empty;
            }

            @Override
            public Set<String> getInjectionTargetInterfaces() {
                return annotations;
            }

            @Override
            public Set<String> getInjectionPointsAnnotations() {
                return this.empty;
            }
        });
        ParsingContext context = null;
        try {
            context = builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Parser parser = new Parser(context);
        final ClassLoader cLoader = this.getClass().getClassLoader();
        Holder<ClassLoader> holder = new Holder<ClassLoader>(){

            @Override
            public ClassLoader get() {
                return cLoader;
            }
        };
        this.habitat = this.newHabitat();
        HashSet<String> cpSet = new HashSet<String>();
        Hk2TestServices.findEntriesInClasspath(cpSet, classPath);
        ArrayList<InhabitantsScanner> metaInfScanners = new ArrayList<InhabitantsScanner>();
        for (String fileName : cpSet) {
            File f = new File(fileName);
            if (!f.exists()) continue;
            try {
                this.logger.log(Level.FINER, "Beginning parsing {0}", fileName);
                if (f.isFile()) {
                    JarFile jarFile = new JarFile(f);
                    JarEntry entry = jarFile.getJarEntry("META-INF/inhabitants/default");
                    if (entry != null) {
                        byte[] buf = new byte[(int)entry.getSize()];
                        DataInputStream in = new DataInputStream(jarFile.getInputStream(entry));
                        try {
                            in.readFully(buf);
                        }
                        finally {
                            in.close();
                        }
                        this.logger.log(Level.FINER, "Using meta-inf file for {0}", f.getPath());
                        metaInfScanners.add(new InhabitantsScanner(new ByteArrayInputStream(buf), "jar:" + f.toURL() + "!/" + entry.getName()));
                    } else {
                        this.parse(parser, f);
                    }
                    jarFile.close();
                    continue;
                }
                File inhabitantFile = new File(f, "META-INF/inhabitants" + File.separator + "default");
                if (inhabitantFile.exists()) {
                    this.logger.log(Level.FINER, "Using meta-inf file for {0}", f.getPath());
                    metaInfScanners.add(new InhabitantsScanner(new BufferedInputStream(new FileInputStream(inhabitantFile)), inhabitantFile.getPath()));
                    continue;
                }
                this.parseAlways(parser, f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            parser.awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.logger.log(Level.FINER, "Starting to introspect");
        InhabitantsParser ip = this.createInhabitantsParser(this.habitat);
        InhabitantIntrospectionScanner is = new InhabitantIntrospectionScanner(context);
        try {
            ip.parse(is, holder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.log(Level.FINER, "finished introspecting");
        this.logger.log(Level.FINER, "Starting to introspect");
        for (InhabitantsScanner scanner : metaInfScanners) {
            try {
                ip.parse(scanner, holder);
                scanner.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.logger.log(Level.FINER, "finished introspecting");
        for (IntrospectionScanner s : this.habitat.getAllByContract(IntrospectionScanner.class)) {
            this.logger.log(Level.FINE, "Found supplemental scanner " + s);
            s.parse(context, holder);
        }
        Iterator<String> contracts = this.habitat.getAllContracts();
        while (contracts.hasNext()) {
            String contract = contracts.next();
            this.logger.log(Level.FINER, "Found contract: {0}", contract);
            for (Inhabitant<?> t : this.habitat.getInhabitantsByContract(contract)) {
                this.logger.log(Level.FINER, " --> {0} {1}", new Object[]{t.typeName(), t.metadata()});
            }
        }
        this.habitat.initialized();
    }

    static void findEntriesInClasspath(Set<String> cpSet, String classPath) {
        if (classPath != null) {
            String[] filenames;
            for (String filename : filenames = classPath.split(File.pathSeparator)) {
                if (filename.equals("")) continue;
                File classpathEntry = new File(filename);
                Hk2TestServices.addTransitiveJars(cpSet, classpathEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTransitiveJars(Set<String> cpSet, File classpathFile) {
        block9: {
            cpSet.add(classpathFile.getAbsolutePath());
            if (classpathFile.exists()) {
                try {
                    String additionalClasspath;
                    Manifest mf;
                    if (!classpathFile.isFile()) break block9;
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(classpathFile);
                        mf = jarFile.getManifest();
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    if (mf != null && (additionalClasspath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        for (String classpathEntry : additionalClasspath.split(" ")) {
                            File mfClasspathFile;
                            if (classpathEntry.equals("") || !(mfClasspathFile = new File(classpathFile.getParent(), classpathEntry.trim())).exists() || cpSet.contains(mfClasspathFile.getAbsolutePath())) continue;
                            Hk2TestServices.addTransitiveJars(cpSet, mfClasspathFile);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Parser parser, File f) throws IOException {
        String imports;
        Manifest manifest = null;
        if (f.isDirectory()) {
            File manifestFile = new File(f, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestFile));
                try {
                    manifest = new Manifest(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        } else {
            JarFile jar = new JarFile(f);
            manifest = jar.getManifest();
            jar.close();
        }
        if (manifest != null && ((imports = manifest.getMainAttributes().getValue("Import-Package")) == null || imports.indexOf("hk2") == -1)) {
            this.logger.log(Level.FINER, "ignoring service-less {0}", f.getName());
            return;
        }
        this.parseAlways(parser, f);
    }

    private void parseAlways(Parser parser, final File f) throws IOException {
        parser.parse(f, new Runnable(){

            @Override
            public void run() {
                Hk2TestServices.this.logger.log(Level.FINER, "Finished introspecting {0}", f.getName());
            }
        });
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public Habitat newHabitat() throws ComponentException {
        if (null != this.habitatFactory) {
            return this.habitatFactory.newHabitat();
        }
        return new Habitat();
    }

    public InhabitantsParser createInhabitantsParser(Habitat h) throws ComponentException {
        if (null != this.ipFactory) {
            return this.ipFactory.createInhabitantsParser(h);
        }
        return new InhabitantsParser(h);
    }
}

