/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.DescriptorArchivist;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.ApplicationNameProvider;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DolProvider
implements ApplicationMetaDataProvider<Application>,
ApplicationNameProvider {
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected DescriptorArchivist descriptorArchivist;
    @Inject
    protected ApplicationArchivist applicationArchivist;
    @Inject
    Habitat habitat;
    @Inject
    DasConfig dasConfig;
    private static String WRITEOUT_XML = System.getProperty("writeout.xml");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DolProvider.class);

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{Application.class, WebBundleDescriptor.class}, null);
    }

    public Application load(DeploymentContext dc) throws IOException {
        ModuleDescriptor md;
        ReadableArchive sourceArchive = dc.getSource();
        ClassLoader cl = dc.getClassLoader();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String name = params.name();
        Archivist archivist = this.archivistFactory.getArchivist(sourceArchive, cl);
        if (archivist == null) {
            throw new RuntimeException(localStrings.getLocalString("invalid.javaee.archive", "Archive [{0}] was deployed as a Java EE archive while it does not contain any valid Java EE components. Please check the packaging of the archive.", new Object[]{name}));
        }
        archivist.setAnnotationProcessingRequested(true);
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        archivist.setXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            archivist.setXMLValidation(false);
        }
        archivist.setRuntimeXMLValidation(false);
        ApplicationHolder holder = (ApplicationHolder)dc.getModuleMetaData(ApplicationHolder.class);
        File deploymentPlan = params.deploymentplan;
        this.handleDeploymentPlan(deploymentPlan, archivist, sourceArchive, holder);
        archivist.setExtraData(Types.class, dc.getModuleMetaData(Types.class));
        archivist.setExtraData(Parser.class, dc.getModuleMetaData(Parser.class));
        long start = System.currentTimeMillis();
        Application application = null;
        if (holder != null) {
            application = holder.app;
            application.setAppName(name);
            if (application.isVirtual()) {
                md = application.getStandaloneBundleDescriptor().getModuleDescriptor();
                md.setModuleName(name);
            }
            try {
                this.applicationFactory.openWith(application, sourceArchive, archivist);
            }
            catch (SAXParseException e) {
                throw new IOException(e);
            }
        }
        try {
            application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
            application.setAppName(name);
            md = application.getStandaloneBundleDescriptor().getModuleDescriptor();
            md.setModuleName(name);
        }
        catch (SAXParseException e) {
            throw new IOException(e);
        }
        application.setRegistrationName(name);
        if (Boolean.valueOf(WRITEOUT_XML).booleanValue()) {
            this.saveAppDescriptor(application, dc);
        }
        Logger.getAnonymousLogger().log(Level.FINE, "DOL Loading time" + (System.currentTimeMillis() - start));
        if (application.isVirtual()) {
            dc.addModuleMetaData((Object)application.getStandaloneBundleDescriptor());
            for (RootDeploymentDescriptor extension : application.getStandaloneBundleDescriptor().getExtensionsDescriptors()) {
                dc.addModuleMetaData((Object)extension);
            }
        }
        this.addModuleConfig(dc, application);
        return application;
    }

    public String getNameFor(ReadableArchive archive, DeploymentContext context) {
        Application application = null;
        try {
            if (archive.exists("META-INF/application.xml") || archive.exists("WEB-INF/web.xml") || archive.exists("META-INF/ejb-jar.xml") || archive.exists("META-INF/application-client.xml") || archive.exists("META-INF/ra.xml")) {
                application = this.applicationFactory.createApplicationFromStandardDD(archive);
                ApplicationHolder holder = new ApplicationHolder(application);
                if (context != null) {
                    context.addModuleMetaData((Object)holder);
                }
                return application.getAppName();
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error occurred", e);
        }
        return null;
    }

    protected void handleDeploymentPlan(File deploymentPlan, Archivist archivist, ReadableArchive sourceArchive, ApplicationHolder holder) throws IOException {
        if (deploymentPlan != null) {
            DeploymentPlanArchive dpa = new DeploymentPlanArchive();
            dpa.open(deploymentPlan.toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            if (archivist instanceof ApplicationArchivist) {
                ((ApplicationArchivist)archivist).copyInto(holder.app, (ReadableArchive)dpa, targetArchive, false);
            } else {
                archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
            }
        }
    }

    protected void saveAppDescriptor(Application application, DeploymentContext context) throws IOException {
        if (application != null) {
            ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
            context.getScratchDir("xml").mkdirs();
            WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
            this.descriptorArchivist.write(application, archive, archive2);
            this.applicationArchivist.copyExtraElements(archive, archive2);
        }
    }

    private void addModuleConfig(DeploymentContext dc, Application application) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (!params.origin.isDeploy()) {
            return;
        }
        try {
            com.sun.enterprise.config.serverbeans.Application app_w = (com.sun.enterprise.config.serverbeans.Application)dc.getTransientAppMetaData("application", com.sun.enterprise.config.serverbeans.Application.class);
            if (app_w != null) {
                if (application.isVirtual()) {
                    Module modConfig = (Module)app_w.createChild(Module.class);
                    app_w.getModule().add(modConfig);
                    modConfig.setName(application.getRegistrationName());
                } else {
                    for (ModuleDescriptor moduleDesc : application.getModules()) {
                        Module modConfig = (Module)app_w.createChild(Module.class);
                        app_w.getModule().add(modConfig);
                        modConfig.setName(moduleDesc.getArchiveUri());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "failed to add the module config", e);
        }
    }
}

