/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.gms.tools;

import com.sun.enterprise.gms.tools.MulticastTester;
import com.sun.enterprise.gms.tools.StringManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiCastReceiverThread
extends Thread {
    static final StringManager sm = StringManager.getInstance();
    final AtomicBoolean receivedAnything = new AtomicBoolean(false);
    int mcPort;
    String mcAddress;
    String bindInterface;
    boolean debug;
    String targetData;

    public MultiCastReceiverThread(int mcPort, String mcAddress, String bindInterface, boolean debug, String targetData) {
        super("McastReceiver");
        this.mcPort = mcPort;
        this.mcAddress = mcAddress;
        this.bindInterface = bindInterface;
        this.debug = debug;
        this.targetData = targetData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block19: {
            DatagramSocket ms;
            InetAddress group;
            block20: {
                group = null;
                ms = null;
                byte[] buffer = new byte[8192];
                group = InetAddress.getByName(this.mcAddress);
                ms = new MulticastSocket(this.mcPort);
                if (this.bindInterface != null) {
                    ((MulticastSocket)ms).setInterface(InetAddress.getByName(this.bindInterface));
                }
                ((MulticastSocket)ms).joinGroup(group);
                System.out.println(sm.get("listening.info", new Object[0]));
                HashSet<String> hosts = new HashSet<String>();
                while (!MultiCastReceiverThread.interrupted()) {
                    DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                    ms.receive(dp);
                    String newData = new String(dp.getData()).trim();
                    this.log(String.format("received '%s'", newData));
                    if (!hosts.add(newData)) continue;
                    if (this.targetData.equals(newData)) {
                        System.out.println(sm.get("loopback.from", MulticastTester.trimDataString(newData)));
                        continue;
                    }
                    System.out.println(sm.get("received.from", MulticastTester.trimDataString(newData)));
                    this.receivedAnything.set(true);
                }
                if (ms == null) break block19;
                if (group == null) break block20;
                this.log("socket leaving group");
                try {
                    ((MulticastSocket)ms).leaveGroup(group);
                }
                catch (IOException ioe) {
                    System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                }
            }
            this.log("closing socket");
            ms.close();
            break block19;
            catch (InterruptedIOException iioe) {
                block21: {
                    this.log(iioe.getMessage());
                    if (ms == null) break block19;
                    if (group == null) break block21;
                    this.log("socket leaving group");
                    try {
                        ((MulticastSocket)ms).leaveGroup(group);
                    }
                    catch (IOException ioe) {
                        System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                    }
                }
                this.log("closing socket");
                ms.close();
            }
            catch (Exception e) {
                block22: {
                    System.err.println(sm.get("whoops", e.toString()));
                    if (ms == null) break block19;
                    if (group == null) break block22;
                    this.log("socket leaving group");
                    {
                        catch (Throwable throwable) {
                            if (ms != null) {
                                if (group != null) {
                                    this.log("socket leaving group");
                                    try {
                                        ((MulticastSocket)ms).leaveGroup(group);
                                    }
                                    catch (IOException ioe) {
                                        System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                                    }
                                }
                                this.log("closing socket");
                                ms.close();
                            }
                            throw throwable;
                        }
                    }
                    try {
                        ((MulticastSocket)ms).leaveGroup(group);
                    }
                    catch (IOException ioe) {
                        System.err.println(sm.get("ignoring.exception.leaving", this.getName(), ioe.toString()));
                    }
                }
                this.log("closing socket");
                ms.close();
            }
        }
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println(String.format("%s: %s", this.getName(), msg));
        }
    }
}

