/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import java.io.Serializable;

public class GrizzlyPeerID
implements Serializable,
Comparable<GrizzlyPeerID> {
    static final long serialVersionUID = 9093067296675025106L;
    public final String host;
    public final int tcpPort;
    public final String multicastAddress;
    public final int multicastPort;
    private final String toStringValue;

    public GrizzlyPeerID(String host, int tcpPort, String multicastAddress, int multicastPort) {
        this.host = host;
        this.multicastAddress = multicastAddress;
        this.tcpPort = tcpPort;
        this.multicastPort = multicastPort;
        this.toStringValue = host + ":" + tcpPort + ":" + multicastAddress + ":" + multicastPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public boolean equals(Object other) {
        if (other instanceof GrizzlyPeerID) {
            GrizzlyPeerID otherPeerID = (GrizzlyPeerID)other;
            if (this.multicastPort == otherPeerID.multicastPort && this.multicastAddress.equals(otherPeerID.multicastAddress)) {
                if (this.host == otherPeerID.host) {
                    return true;
                }
                return this.host != null && this.host.equals(otherPeerID.host);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.host != null) {
            result = 37 * result + this.host.hashCode();
        }
        result = 37 * result + this.multicastAddress.hashCode();
        result = 37 * result + this.multicastPort;
        return result;
    }

    public String toString() {
        return this.toStringValue;
    }

    @Override
    public int compareTo(GrizzlyPeerID other) {
        int result = 0;
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        if (this.host != null && other.host != null && (result = this.host.compareTo(other.host)) != 0) {
            return result;
        }
        result = this.multicastPort - other.getMulticastPort();
        if (result != 0) {
            return result;
        }
        result = this.multicastAddress.compareTo(other.getMulticastAddress());
        return result;
    }
}

