/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly;

import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.mgmt.transport.AbstractMessageSender;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyUtil;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyTCPConnectorWrapper
extends AbstractMessageSender {
    private static final Logger LOG = GrizzlyUtil.getLogger();
    private final Controller controller;
    private final long writeTimeout;
    private final InetSocketAddress localSocketAddress;

    public GrizzlyTCPConnectorWrapper(Controller controller, long writeTimeout, String host, int port, PeerID<GrizzlyPeerID> localPeerID) {
        this.controller = controller;
        this.writeTimeout = writeTimeout;
        this.localSocketAddress = host != null ? new InetSocketAddress(host, port) : null;
        this.localPeerID = localPeerID;
    }

    @Override
    protected boolean doSend(PeerID peerID, Message message) throws IOException {
        if (peerID == null) {
            throw new IOException("peer ID can not be null");
        }
        Object uniqueID = peerID.getUniqueID();
        if (!(uniqueID instanceof GrizzlyPeerID)) {
            throw new IOException("peer ID must be GrizzlyPeerID type");
        }
        GrizzlyPeerID grizzlyPeerID = (GrizzlyPeerID)uniqueID;
        InetSocketAddress remoteSocketAddress = new InetSocketAddress(grizzlyPeerID.getHost(), grizzlyPeerID.getTcpPort());
        try {
            return this.send(remoteSocketAddress, null, message);
        }
        catch (IOException ie) {
            return this.send(remoteSocketAddress, null, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send(SocketAddress remoteAddress, SocketAddress localAddress, Message message) throws IOException {
        if (this.controller == null) {
            throw new IOException("grizzly controller must be initialized");
        }
        if (remoteAddress == null) {
            throw new IOException("remote address can not be null");
        }
        if (message == null) {
            throw new IOException("message can not be null");
        }
        ConnectorHandler connectorHandler = null;
        try {
            block21: {
                connectorHandler = this.controller.acquireConnectorHandler(Controller.Protocol.TCP);
                try {
                    connectorHandler.connect(remoteAddress, localAddress);
                }
                catch (Throwable io) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "handled exception during connect to remote address: " + remoteAddress + ": workaround for shoal issue 106: retry one more time to connect", io);
                    }
                    if (connectorHandler != null) {
                        try {
                            connectorHandler.close();
                        }
                        catch (IOException e) {
                            LOG.log(Level.FINE, "send: exception closing connectorHandler", e);
                        }
                        finally {
                            this.controller.releaseConnectorHandler(connectorHandler);
                            connectorHandler = null;
                        }
                    }
                    connectorHandler = this.controller.acquireConnectorHandler(Controller.Protocol.TCP);
                    connectorHandler.connect(remoteAddress, localAddress);
                    if (!LOG.isLoggable(Level.FINE)) break block21;
                    LOG.log(Level.FINE, "reconnect succeeded to remote address:" + remoteAddress + " for message " + message.toString());
                }
            }
            OutputWriter.flushChannel((SelectableChannel)connectorHandler.getUnderlyingChannel(), (ByteBuffer)message.getPlainByteBuffer(), (long)this.writeTimeout);
        }
        finally {
            if (connectorHandler != null) {
                try {
                    connectorHandler.close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "send: exception closing connectorHandler", e);
                }
                this.controller.releaseConnectorHandler(connectorHandler);
            }
        }
        return true;
    }
}

