/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.EmbeddedProviderContainerContractInfo;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.JPApplicationContainer;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.ServerProviderContainerContractInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, JPApplicationContainer>
implements PostConstruct,
EventListener {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironmentImpl serverEnvironment;
    @Inject
    private Events events;
    @Inject
    private ApplicationRegistry applicationRegistry;
    private static final String EMF_KEY = EntityManagerFactory.class.toString();

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin.isUndeploy() && this.isDas()) {
            Java2DBProcessorHelper helper = new Java2DBProcessorHelper(dc);
            helper.init();
            helper.createOrDropTablesInDB(false, "JPA");
        }
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        boolean prepared = super.prepare(context);
        if (prepared) {
            Application application = (Application)context.getModuleMetaData(Application.class);
            Set bundles = application.getBundleDescriptors();
            final ArrayList<PersistenceUnitDescriptor> referencedPus = new ArrayList<PersistenceUnitDescriptor>();
            for (BundleDescriptor bundle : bundles) {
                Collection pusReferencedFromBundle = bundle.findReferencedPUs();
                for (PersistenceUnitDescriptor pud : pusReferencedFromBundle) {
                    referencedPus.add(pud);
                }
            }
            PersistenceUnitDescriptorIterator pudIterator = new PersistenceUnitDescriptorIterator(){

                void visitPUD(PersistenceUnitDescriptor pud, DeploymentContext context) {
                    if (referencedPus.contains(pud)) {
                        boolean isDas = JPADeployer.this.isDas();
                        ServerProviderContainerContractInfo providerContainerContractInfo = JPADeployer.this.serverEnvironment.isEmbedded() ? new EmbeddedProviderContainerContractInfo(context, JPADeployer.this.connectorRuntime, JPADeployer.this.habitat, isDas) : new ServerProviderContainerContractInfo(context, JPADeployer.this.connectorRuntime, isDas);
                        PersistenceUnitLoader puLoader = new PersistenceUnitLoader(pud, providerContainerContractInfo);
                        context.addTransientAppMetaData(JPADeployer.getUniquePuIdentifier(pud), (Object)puLoader);
                    }
                }
            };
            pudIterator.iteratePUDs(context);
        }
        return prepared;
    }

    public JPApplicationContainer load(JPAContainer container, DeploymentContext context) {
        return new JPApplicationContainer();
    }

    private static String getUniquePuIdentifier(PersistenceUnitDescriptor pud) {
        return pud.getAbsolutePuRoot() + pud.getName();
    }

    private boolean isDas() {
        return this.serverEnvironment.isDas() || this.serverEnvironment.isEmbedded();
    }

    @Override
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event event) {
        ApplicationInfo appInfo;
        List emfsCreatedForThisApp;
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)event.hook();
            Map deploymentContexts = context.getModuleDeploymentContexts();
            for (ExtendedDeploymentContext deploymentContext : deploymentContexts.values()) {
                this.iterateInitializedPUsAtApplicationPrepare((DeploymentContext)deploymentContext);
            }
            this.iterateInitializedPUsAtApplicationPrepare((DeploymentContext)context);
        } else if (event.is(Deployment.APPLICATION_DISABLED) && (emfsCreatedForThisApp = (List)(appInfo = (ApplicationInfo)event.hook()).getTransientAppMetaData(EMF_KEY, List.class)) != null) {
            for (EntityManagerFactory entityManagerFactory : emfsCreatedForThisApp) {
                entityManagerFactory.close();
            }
            appInfo.addTransientAppMetaData(EMF_KEY, null);
        }
    }

    private void iterateInitializedPUsAtApplicationPrepare(DeploymentContext context) {
        DeployCommandParameters commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        String appName = commandParams.name;
        final ApplicationInfo appInfo = this.applicationRegistry.get(appName);
        PersistenceUnitDescriptorIterator pudIterator = new PersistenceUnitDescriptorIterator(){

            void visitPUD(PersistenceUnitDescriptor pud, DeploymentContext context) {
                PersistenceUnitLoader puLoader = (PersistenceUnitLoader)context.getTransientAppMetaData(JPADeployer.getUniquePuIdentifier(pud), PersistenceUnitLoader.class);
                if (puLoader != null) {
                    ArrayList<EntityManagerFactory> emfsCreatedForThisApp;
                    if (JPADeployer.this.isDas()) {
                        puLoader.doJava2DB();
                    }
                    if ((emfsCreatedForThisApp = (ArrayList<EntityManagerFactory>)appInfo.getTransientAppMetaData(EMF_KEY, List.class)) == null) {
                        emfsCreatedForThisApp = new ArrayList<EntityManagerFactory>();
                        appInfo.addTransientAppMetaData(EMF_KEY, emfsCreatedForThisApp);
                    }
                    emfsCreatedForThisApp.add(puLoader.getEMF());
                }
            }
        };
        pudIterator.iteratePUDs(context);
    }

    private static abstract class PersistenceUnitDescriptorIterator {
        private PersistenceUnitDescriptorIterator() {
        }

        void iteratePUDs(DeploymentContext context) {
            RootDeploymentDescriptor currentBundle = (RootDeploymentDescriptor)context.getModuleMetaData(BundleDescriptor.class);
            if (currentBundle == null) {
                currentBundle = (RootDeploymentDescriptor)context.getModuleMetaData(Application.class);
            }
            Collection pusDescriptorForThisBundle = currentBundle.getExtensionsDescriptors(PersistenceUnitsDescriptor.class);
            for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : pusDescriptorForThisBundle) {
                for (PersistenceUnitDescriptor pud : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                    this.visitPUD(pud, context);
                }
            }
        }

        abstract void visitPUD(PersistenceUnitDescriptor var1, DeploymentContext var2);
    }
}

