/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandLockTimeoutException;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class AdminCommandLock {
    @Inject
    Logger logger;
    private ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private SuspendCommandsLockThread suspendCommandsLockThread = null;
    private boolean suspendCommandsTimedOut = false;
    private String lockOwner = null;
    private Date lockTimeOfAcquisition = null;

    public Lock getLock(CommandLock.LockType type2) {
        if (type2 == CommandLock.LockType.SHARED) {
            return this.rwlock.readLock();
        }
        if (type2 == CommandLock.LockType.EXCLUSIVE) {
            return this.rwlock.writeLock();
        }
        return null;
    }

    public Lock getLock(AdminCommand command) {
        CommandLock alock = command.getClass().getAnnotation(CommandLock.class);
        if (alock == null || alock.value() == CommandLock.LockType.SHARED) {
            return this.rwlock.readLock();
        }
        if (alock.value() == CommandLock.LockType.EXCLUSIVE) {
            return this.rwlock.writeLock();
        }
        return null;
    }

    public Lock getLock(AdminCommand command, int timeout, String owner) throws AdminCommandLockTimeoutException {
        Lock lock = null;
        boolean exclusive = false;
        CommandLock alock = command.getClass().getAnnotation(CommandLock.class);
        if (alock == null || alock.value() == CommandLock.LockType.SHARED) {
            lock = this.rwlock.readLock();
        } else if (alock.value() == CommandLock.LockType.EXCLUSIVE) {
            lock = this.rwlock.writeLock();
            exclusive = true;
        }
        if (lock == null) {
            return null;
        }
        boolean lockAcquired = false;
        while (!lockAcquired) {
            try {
                if (lock.tryLock(timeout, TimeUnit.SECONDS)) {
                    lockAcquired = true;
                    continue;
                }
                throw new AdminCommandLockTimeoutException("timeout acquiring lock", this.getLockTimeOfAcquisition(), this.getLockOwner());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted acquiring command lock. ", e);
            }
        }
        if (lockAcquired && exclusive) {
            this.setLockOwner(owner);
            this.setLockTimeOfAcquisition(new Date());
        }
        return lock;
    }

    private void setLockOwner(String owner) {
        this.lockOwner = owner;
    }

    public synchronized String getLockOwner() {
        return this.lockOwner;
    }

    private void setLockTimeOfAcquisition(Date time) {
        this.lockTimeOfAcquisition = time;
    }

    public synchronized Date getLockTimeOfAcquisition() {
        return this.lockTimeOfAcquisition;
    }

    public synchronized SuspendStatus suspendCommands(long timeout, String lockOwner) {
        ArrayBlockingQueue<SuspendStatus> suspendStatusQ = new ArrayBlockingQueue<SuspendStatus>(1);
        if (this.suspendCommandsLockThread != null && this.suspendCommandsLockThread.isAlive()) {
            return SuspendStatus.ILLEGALSTATE;
        }
        this.suspendCommandsTimedOut = false;
        this.suspendCommandsLockThread = new SuspendCommandsLockThread(timeout, suspendStatusQ, lockOwner);
        try {
            this.suspendCommandsLockThread.setName("DAS Suspended Command Lock Thread");
            this.suspendCommandsLockThread.setDaemon(true);
        }
        catch (IllegalThreadStateException e) {
            return SuspendStatus.ERROR;
        }
        catch (SecurityException e) {
            return SuspendStatus.ERROR;
        }
        this.suspendCommandsLockThread.start();
        SuspendStatus suspendStatus = this.queueTake(suspendStatusQ);
        return suspendStatus;
    }

    public synchronized Thread resumeCommands() {
        if (this.suspendCommandsLockThread == null || !this.suspendCommandsLockThread.isAlive() || this.suspendCommandsLockThread.resumeCommandsSemaphore == null) {
            return null;
        }
        this.suspendCommandsLockThread.resumeCommandsSemaphore.release();
        return this.suspendCommandsLockThread;
    }

    private void queuePut(BlockingQueue<SuspendStatus> itmQ, SuspendStatus status) {
        boolean itemPut = false;
        while (!itemPut) {
            try {
                itmQ.put(status);
                itemPut = true;
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted putting lock status on queue", e);
            }
        }
    }

    private SuspendStatus queueTake(BlockingQueue<SuspendStatus> itmQ) {
        SuspendStatus status = SuspendStatus.SUCCESS;
        boolean itemTake = false;
        while (!itemTake) {
            try {
                status = itmQ.take();
                itemTake = true;
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINE, "Interrupted getting status from a suspend queue", e);
            }
        }
        return status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuspendCommandsLockThread
    extends Thread {
        private Semaphore resumeCommandsSemaphore;
        private BlockingQueue<SuspendStatus> suspendStatusQ;
        private boolean suspendCommandsTimedOut;
        private long timeout;
        private String lockOwner;

        public SuspendCommandsLockThread(long timeout, BlockingQueue<SuspendStatus> suspendStatusQ, String lockOwner) {
            this.suspendStatusQ = suspendStatusQ;
            this.timeout = timeout;
            this.lockOwner = lockOwner;
            this.resumeCommandsSemaphore = null;
            this.suspendCommandsTimedOut = false;
        }

        @Override
        public void run() {
            Lock lock = AdminCommandLock.this.getLock(CommandLock.LockType.EXCLUSIVE);
            boolean lockAcquired = false;
            while (!lockAcquired && !this.suspendCommandsTimedOut) {
                try {
                    if (lock.tryLock(this.timeout, TimeUnit.SECONDS)) {
                        lockAcquired = true;
                        continue;
                    }
                    this.suspendCommandsTimedOut = true;
                }
                catch (InterruptedException e) {
                    AdminCommandLock.this.logger.log(Level.FINE, "Interrupted acquiring command lock. ", e);
                }
            }
            if (lockAcquired) {
                AdminCommandLock.this.setLockOwner(this.lockOwner);
                AdminCommandLock.this.setLockTimeOfAcquisition(new Date());
                this.resumeCommandsSemaphore = new Semaphore(0, true);
            }
            if (this.suspendStatusQ != null) {
                if (this.suspendCommandsTimedOut) {
                    AdminCommandLock.this.queuePut(this.suspendStatusQ, SuspendStatus.TIMEOUT);
                } else {
                    AdminCommandLock.this.queuePut(this.suspendStatusQ, SuspendStatus.SUCCESS);
                }
            }
            if (this.suspendCommandsTimedOut) {
                return;
            }
            this.semaphoreWait(this.resumeCommandsSemaphore, "Interrupted waiting on resume semaphore");
            lock.unlock();
        }

        private void semaphoreWait(Semaphore s, String logMsg) {
            boolean semaphoreReleased = false;
            while (!semaphoreReleased) {
                try {
                    s.acquire();
                    semaphoreReleased = true;
                }
                catch (InterruptedException e) {
                    AdminCommandLock.this.logger.log(Level.FINE, logMsg, e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SuspendStatus {
        SUCCESS,
        TIMEOUT,
        ILLEGALSTATE,
        ERROR;

    }
}

