/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupFilenameManager;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupRestoreManager;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.StringHelper;
import com.sun.enterprise.backup.ZipStorage;
import com.sun.enterprise.backup.util.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.List;

public class BackupManager
extends BackupRestoreManager {
    Status status;

    public BackupManager(BackupRequest req) throws BackupException {
        super(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String backup() throws BackupException {
        String mesg = "";
        String statusString = this.writeStatus();
        if (!this.request.terse) {
            String backupTime = new Date(this.request.timestamp).toString();
            mesg = StringHelper.get("backup-res.SuccessfulBackup", this.request.domainName, backupTime);
        }
        try {
            ZipStorage zs = new ZipStorage(this.request);
            zs.store();
            BackupFilenameManager bfm = new BackupFilenameManager(this.getBackupDirectory(this.request), this.request.domainName);
            List<File> recycleFiles = bfm.getRecycleFiles(this.request.recycleLimit);
            if (recycleFiles.size() > 0 && this.request.verbose) {
                mesg = mesg + "\n" + StringHelper.get("backup-res.recycle", this.request.recycleLimit) + "\n";
            }
            for (File f : recycleFiles) {
                if (this.request.verbose) {
                    mesg = mesg + StringHelper.get("backup-res.recycleDelete", f) + "\n";
                }
                if (f.delete()) continue;
                mesg = mesg + StringHelper.get("backup-res.recycleBadDelete", f) + "\n";
            }
            if (this.request.verbose) {
                mesg = mesg + "\n\n" + statusString;
            }
            String string = mesg;
            return string;
        }
        finally {
            this.status.delete();
            FileUtils.protect(this.request.backupFile);
        }
    }

    void init() throws BackupException {
        super.init();
        if (this.request.backupFile != null) {
            throw new BackupException("backup-res.InternalError", "No backupFilename may be specified for a backup -- it is reserved for restore operations only.");
        }
        if (!FileUtils.safeIsDirectory(this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        File backupDir = this.getBackupDirectory(this.request);
        backupDir.mkdirs();
        if (!FileUtils.safeIsDirectory(backupDir)) {
            throw new BackupException("backup-res.NoBackupDirCantCreate", backupDir);
        }
        BackupFilenameManager bfmgr = new BackupFilenameManager(backupDir, this.request.domainName);
        this.request.backupFile = bfmgr.next();
        if (this.request.description == null || this.request.description.length() <= 0) {
            this.request.description = bfmgr.getCustomizedDescription();
        }
    }

    private String writeStatus() {
        this.status = new Status();
        return this.status.write(this.request);
    }
}

