/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.LoadResponseCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class BroadcastLoadRequestCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private K key;
    CommandResponse resp;
    private Future future;
    private long tokenId;
    private String originatingInstance;

    public BroadcastLoadRequestCommand() {
        super((byte)41);
    }

    public BroadcastLoadRequestCommand(K key) {
        this();
        this.key = key;
    }

    @Override
    protected BroadcastLoadRequestCommand<K, V> createNewInstance() {
        return new BroadcastLoadRequestCommand<K, V>();
    }

    @Override
    public boolean computeTarget() {
        this.setTargetName(null);
        return true;
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.originatingInstance = this.dsc.getInstanceName();
        this.setTargetName(null);
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        ros.writeLong(this.resp.getTokenId());
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
        ros.writeLengthPrefixedString(this.originatingInstance);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.originatingInstance = ris.readLengthPrefixedString();
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) {
        block6: {
            try {
                DataStoreEntry e = this.dsc.getReplicaStore().getEntry(this.key);
                if (e == null || this.originatingInstance.equals(this.dsc.getInstanceName())) break block6;
                DataStoreEntry dataStoreEntry = e;
                synchronized (dataStoreEntry) {
                    if (!e.isRemoved() && e.getV() != null) {
                        LoadResponseCommand rsp = new LoadResponseCommand(this.key, this.dsc.getDataStoreEntryHelper().getV(e), this.tokenId);
                        rsp.setOriginatingInstance(this.originatingInstance);
                        this.getCommandManager().execute(rsp);
                    }
                }
            }
            catch (DataStoreException dsEx) {
                this.resp.setException(dsEx);
            }
        }
    }

    public V getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        try {
            Object result = this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            return result;
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result " + timeoutEx);
            return null;
        }
        catch (ExecutionException exeEx) {
            throw new DataStoreException(exeEx);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

