/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class SizeResponseCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.size");
    private long tokenId;
    private int size;
    private String originatingInstance;
    private String respondingInstanceName;

    public SizeResponseCommand() {
        super((byte)52);
    }

    public SizeResponseCommand(String originatingInstance, long tokenId, int size) {
        this();
        this.originatingInstance = originatingInstance;
        this.tokenId = tokenId;
        this.size = size;
    }

    @Override
    protected SizeResponseCommand<K, V> createNewInstance() {
        return new SizeResponseCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.setTargetName(this.originatingInstance);
        ros.writeLong(this.tokenId);
        ros.writeInt(this.size);
        ros.writeLengthPrefixedString(this.dsc.getInstanceName());
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.size = ris.readInt();
        this.respondingInstanceName = ris.readLengthPrefixedString();
    }

    @Override
    public void execute(String initiator) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + " executed size_response tokenId=" + this.tokenId + " value " + this.size);
            }
            resp.setRespondingInstanceName(this.respondingInstanceName);
            resp.setResult(this.size);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.tokenId + ")";
    }
}

