/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class ListBackingStoreConfigurationResponseCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.monitor");
    ArrayList<String> confList;
    private long tokenId;
    private String originatingInstance;

    public ListBackingStoreConfigurationResponseCommand() {
        super((byte)86);
    }

    public ListBackingStoreConfigurationResponseCommand(String originatingInstance, long tokenId, ArrayList<String> confList) {
        this();
        this.originatingInstance = originatingInstance;
        this.tokenId = tokenId;
        this.confList = confList;
    }

    @Override
    protected ListBackingStoreConfigurationResponseCommand<K, V> createNewInstance() {
        return new ListBackingStoreConfigurationResponseCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.setTargetName(this.originatingInstance);
        ros.writeLong(this.tokenId);
        ros.writeLengthPrefixedString(this.originatingInstance);
        ros.writeInt(this.confList.size());
        for (String str : this.confList) {
            ros.writeLengthPrefixedString(str);
        }
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.originatingInstance = ris.readLengthPrefixedString();
        int sz = ris.readInt();
        this.confList = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            this.confList.add(ris.readLengthPrefixedString());
        }
    }

    @Override
    public void execute(String initiator) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            resp.setResult(this.confList);
        }
    }
}

