/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.AbstractCommandInterceptor;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.group.GroupService;

public final class TransmitInterceptor<K, V>
extends AbstractCommandInterceptor<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.interceptor.transmit");

    @Override
    public void onTransmit(Command<K, V> cmd, String initiator) throws DataStoreException {
        DataStoreContext ctx = this.getDataStoreContext();
        ReplicationOutputStream ros = new ReplicationOutputStream();
        try {
            cmd.write(ros);
            byte[] data = ros.toByteArray();
            GroupService gs = ctx.getGroupService();
            gs.sendMessage(cmd.getTargetName(), ctx.getServiceName(), data);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.storeName + ": TransmitInterceptor." + ctx.getServiceName() + ":onTransmit() Sent " + cmd + " to " + (cmd.getTargetName() == null ? " ALL MEMBERS " : cmd.getTargetName()) + "; size: " + data.length);
            }
        }
        catch (IOException ioEx) {
            throw new DataStoreException("Error DURING transmit...", ioEx);
        }
    }
}

