/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class DataFrame {
    private static final Logger logger = Logger.getLogger("websocket");
    private String payload;
    private byte[] bytes;
    private FrameType type;

    public static DataFrame read(NetworkHandler handler) throws IOException {
        DataFrame frame = null;
        Iterator set = EnumSet.allOf(FrameType.class).iterator();
        while (frame == null && set.hasNext()) {
            FrameType frameType = (FrameType)((Object)set.next());
            if (!frameType.accept(handler)) continue;
            frame = new DataFrame(frameType);
            frame.setBytes(frameType.unframe(handler));
        }
        return frame;
    }

    public DataFrame(FrameType frameType) {
        this.type = frameType;
    }

    public DataFrame(String data) {
        this.type = FrameType.TEXT;
        this.payload = data;
        try {
            this.bytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    public String getTextPayload() {
        if (this.payload == null && this.bytes != null) {
            try {
                this.payload = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.payload;
    }

    public void setTextPayload(String payload) {
        this.type = FrameType.TEXT;
        this.payload = payload;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBinaryPayload() {
        return this.bytes;
    }

    public byte[] frame() {
        return this.frame(this.type);
    }

    public byte[] frame(FrameType type) {
        return type.frame(this.bytes);
    }

    public void respond(WebSocket socket) throws IOException {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "payload='" + this.getTextPayload() + '\'' + ", type=" + (Object)((Object)this.type) + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

