/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.glassfish.internal.api.LogManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class FileLoggerHandler
extends Handler
implements PostConstruct {
    @Inject(optional=true)
    LogManager logManager = null;
    @Inject(optional=true)
    Formatter logFormatter;
    private String webLogger = "javax.enterprise.system.container.web.com.sun.enterprise.web";
    private String catalinaLogger = "org.apache.catalina";
    private FileOutputStream fileOutputStream;
    private PrintWriter printWriter;

    public void postConstruct() {
        this.setLevel(Level.OFF);
        if (this.logFormatter != null) {
            this.setFormatter(this.logFormatter);
        }
    }

    public void setLogFile(String logFile) {
        try {
            this.fileOutputStream = new FileOutputStream(logFile, true);
            this.printWriter = new PrintWriter(this.fileOutputStream);
            if (this.logManager != null) {
                this.logManager.addHandler((Handler)this);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void publish(LogRecord record) {
        if (this.getFilter() != null && !this.getFilter().isLoggable(record)) {
            return;
        }
        if (this.fileOutputStream == null || this.printWriter == null) {
            return;
        }
        if (this.webLogger.equals(record.getLoggerName()) || this.catalinaLogger.equals(record.getLoggerName())) {
            this.printWriter.write(this.getFormatter().format(record));
            this.printWriter.flush();
        }
    }

    public void close() {
        this.printWriter.close();
    }

    public void flush() {
        this.printWriter.flush();
    }

    public void setLevel(String logLevel) {
        if ("SEVERE".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.SEVERE);
        } else if ("WARNING".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.WARNING);
        } else if ("INFO".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.INFO);
        } else if ("CONFIG".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.CONFIG);
        } else if ("FINE".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.FINE);
        } else if ("FINER".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.FINER);
        } else if ("FINEST".equalsIgnoreCase(logLevel)) {
            this.setLevel(Level.FINEST);
        } else {
            this.setLevel(Level.INFO);
        }
    }
}

