/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.LoggingConfig;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Contract
public class LoggingConfigImpl
implements LoggingConfig,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    Properties props = new Properties();
    FileInputStream fis;
    String loggingPropertiesName;
    LogManager logMgr = null;
    File loggingConfigDir = null;
    File file = null;
    File libFolder = null;

    @Override
    public void postConstruct() {
        this.setupConfigDir(this.env.getConfigDirPath(), this.env.getLibPath());
    }

    public void setupConfigDir(File file, File installDir) {
        this.loggingConfigDir = file;
        this.loggingPropertiesName = "logging.properties";
        this.logMgr = LogManager.getLogManager();
        this.libFolder = new File(installDir, "lib");
    }

    private boolean openPropFile() throws IOException {
        try {
            this.props = new Properties();
            this.file = new File(this.loggingConfigDir, this.loggingPropertiesName);
            this.fis = new FileInputStream(this.file);
            this.props.load(this.fis);
            this.fis.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot read logging.properties file : ", e);
            throw new IOException();
        }
    }

    public boolean copyLoggingPropertiesFile(File targetDir) throws IOException {
        Logger.getAnonymousLogger().log(Level.WARNING, "Logging.properties file not found, creating new file using DAS logging.properties");
        String rootFolder = this.env.getProps().get("com.sun.aas.installRoot");
        String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
        File src = new File(templateDir, "logging.properties");
        File dest = new File(targetDir, "logging.properties");
        try {
            FileUtils.copy(src, dest);
            return true;
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot create logging.properties file : ", e);
            throw new IOException();
        }
    }

    private boolean openPropFile(String target) throws IOException {
        try {
            this.props = new Properties();
            String pathForLoggingFile = this.loggingConfigDir.getAbsolutePath() + File.separator + target + "-config";
            File dirForLogging = new File(pathForLoggingFile);
            this.file = new File(dirForLogging, this.loggingPropertiesName);
            if (!this.file.exists()) {
                this.copyLoggingPropertiesFile(dirForLogging);
                this.file = new File(dirForLogging, this.loggingPropertiesName);
            }
            this.fis = new FileInputStream(this.file);
            this.props.load(this.fis);
            this.fis.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot read logging.properties file : ", e);
            throw new IOException();
        }
    }

    private void closePropFile() throws IOException {
        try {
            FileOutputStream ois = new FileOutputStream(this.file);
            this.props.store(ois, "GlassFish logging.properties list");
            ois.close();
        }
        catch (FileNotFoundException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot close logging.properties file : ", e);
            throw new IOException();
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot close logging.properties file : ", e);
            throw new IOException();
        }
    }

    private void setWebLoggers(String value) {
        String property = null;
        property = (String)this.props.setProperty("org.apache.catalina.level", value);
        property = (String)this.props.setProperty("org.apache.coyote.level", value);
        property = (String)this.props.setProperty("org.apache.jasper.level", value);
    }

    @Override
    public String setLoggingProperty(String propertyName, String propertyValue) throws IOException {
        if (!this.openPropFile()) {
            return null;
        }
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("javax.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile();
        return property;
    }

    @Override
    public String setLoggingProperty(String propertyName, String propertyValue, String target) throws IOException {
        if (!this.openPropFile(target)) {
            return null;
        }
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("javax.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile();
        return property;
    }

    @Override
    public Map<String, String> updateLoggingProperties(Map<String, String> properties) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            if (!this.openPropFile()) {
                return null;
            }
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (e.getValue() == null) continue;
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                String property = (String)this.props.setProperty(key, e.getValue());
                if (e.getKey().contains("javax.enterprise.system.container.web")) {
                    this.setWebLoggers(e.getValue());
                }
                m.put(key, property);
            }
            this.closePropFile();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m;
    }

    @Override
    public Map<String, String> updateLoggingProperties(Map<String, String> properties, String target) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            if (!this.openPropFile(target)) {
                return null;
            }
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (e.getValue() == null) continue;
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                String property = (String)this.props.setProperty(key, e.getValue());
                if (e.getKey().contains("javax.enterprise.system.container.web")) {
                    this.setWebLoggers(e.getValue());
                }
                m.put(key, property);
            }
            this.closePropFile();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            // empty catch block
        }
        return m;
    }

    @Override
    public Map<String, String> getLoggingProperties(String targetServer) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (!this.openPropFile(targetServer)) {
            return null;
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        return m;
    }

    @Override
    public Map<String, String> getLoggingProperties() throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (!this.openPropFile()) {
            return null;
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        return m;
    }

    @Override
    public void removeLoggingProperties(Set<String> properties) throws IOException {
        this.openPropFile();
        Iterator<String> i = properties.iterator();
        while (i.hasNext()) {
            try {
                String p = i.next();
                this.logger.log(Level.FINER, "Remove from logging.properties file property ", p);
                this.props.remove(p);
            }
            catch (NoSuchElementException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Attempt to remove nonexistent property ", e);
            }
        }
        this.closePropFile();
        try {
            this.logMgr.readConfiguration();
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot reconfigure LogManager : ", e);
            throw new IOException();
        }
    }

    private String getZipFileName(String sourceDir) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        String zipFile = sourceDir + File.separator + "log_" + currentTime + ".zip";
        return zipFile;
    }

    @Override
    public String createZipFile(String sourceDir) throws IOException {
        String zipFile = this.getZipFileName(sourceDir);
        boolean zipDone = false;
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            zipDone = this.addDirectory(zout, fileSource);
            zout.close();
        }
        catch (IOException ioe) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
            throw ioe;
        }
        return zipFile;
    }

    private boolean addDirectory(ZipOutputStream zout, File fileSource) throws IOException {
        boolean zipDone = false;
        File[] files = fileSource.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(zout, files[i]);
                continue;
            }
            if (files[i].getAbsolutePath().contains(".zip")) continue;
            try {
                int length;
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(files[i].getAbsolutePath());
                zout.putNextEntry(new ZipEntry(files[i].getAbsolutePath()));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
                zipDone = true;
                continue;
            }
            catch (IOException ioe) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                throw ioe;
            }
        }
        return zipDone;
    }
}

