/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.glassfish.api.admin.InstanceState;
import org.jvnet.hk2.component.Habitat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceStateFileProcessor {
    private Document xmlDoc = null;
    private String fileName;
    private Habitat habitat;
    private HashMap<String, InstanceState> instanceStates;
    private Domain domain;
    private Map<String, InstanceState.StateType> stringToStateTypeMap;

    public InstanceStateFileProcessor(Habitat habitat, HashMap<String, InstanceState> st, Domain domain, String xmlFile) {
        this.habitat = habitat;
        this.instanceStates = st;
        this.domain = domain;
        this.fileName = xmlFile;
        this.stringToStateTypeMap = new HashMap<String, InstanceState.StateType>();
        this.stringToStateTypeMap.put(InstanceState.StateType.NO_RESPONSE.getDescription(), InstanceState.StateType.NO_RESPONSE);
        this.stringToStateTypeMap.put(InstanceState.StateType.NOT_RUNNING.getDescription(), InstanceState.StateType.NOT_RUNNING);
        this.stringToStateTypeMap.put(InstanceState.StateType.STARTING.getDescription(), InstanceState.StateType.STARTING);
        this.stringToStateTypeMap.put(InstanceState.StateType.RUNNING.getDescription(), InstanceState.StateType.RUNNING);
        this.stringToStateTypeMap.put(InstanceState.StateType.RESTART_REQUIRED.getDescription(), InstanceState.StateType.RESTART_REQUIRED);
    }

    public void parse() throws Exception {
        File xmlFileObject = new File(this.fileName);
        if (!xmlFileObject.exists() || xmlFileObject.length() == 0L) {
            this.createNewInstanceStateFile(xmlFileObject);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.xmlDoc = builder.parse(this.fileName);
        this.parseInstanceStateFile();
    }

    private void createNewInstanceStateFile(File xmlFileObject) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(xmlFileObject));
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        writer.newLine();
        writer.write("<instance-state version=\"1.0\">");
        writer.newLine();
        writer.write("<gms-enabled>false</gms-enabled>");
        writer.newLine();
        for (Server s : this.domain.getServers().getServer()) {
            if (s.isDas()) continue;
            writer.write("<instance name=\"" + s.getName() + "\" state=\"" + InstanceState.StateType.NO_RESPONSE.getDescription() + "\" />");
            writer.newLine();
        }
        writer.write("</instance-state>");
        writer.newLine();
        writer.flush();
        writer.close();
    }

    public void addNewServer(String name) throws Exception {
        if (this.xmlDoc == null) {
            File xmlFileObject = new File(this.fileName);
            if (xmlFileObject.exists()) {
                xmlFileObject.delete();
            }
            this.parse();
        } else {
            Node parentNode = this.xmlDoc.getElementsByTagName("instance-state").item(0);
            Element insNode = this.xmlDoc.createElement("instance");
            insNode.setAttribute("name", name);
            insNode.setAttribute("state", InstanceState.StateType.NO_RESPONSE.getDescription());
            parentNode.appendChild(insNode);
            this.writeDoc(new FileOutputStream(this.fileName));
        }
    }

    private void parseInstanceStateFile() {
        NodeList list = this.xmlDoc.getElementsByTagName("instance");
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            this.parseInstanceElement(list.item(i));
        }
    }

    private void parseInstanceElement(Node n) {
        String name = null;
        String state = null;
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            name = this.getNodeValue(attrs.getNamedItem("name"));
            state = this.getNodeValue(attrs.getNamedItem("state"));
        }
        if (name == null) {
            return;
        }
        InstanceState newInstanceState = null;
        newInstanceState = state == null ? new InstanceState(InstanceState.StateType.NO_RESPONSE) : new InstanceState(this.stringToStateTypeMap.get(state));
        NodeList list = n.getChildNodes();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            String t = list.item(i).getTextContent();
            if ("\n".equals(t)) continue;
            newInstanceState.addFailedCommands(t);
        }
        this.instanceStates.put(name, newInstanceState);
    }

    private String getNodeValue(Node x) {
        return x == null ? null : x.getNodeValue();
    }

    private void writeDoc(OutputStream outputStream) throws Exception {
        TransformerFactory transformerfactory = TransformerFactory.newInstance();
        Transformer transformer = transformerfactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "yes");
        DOMSource domSource = new DOMSource(this.xmlDoc);
        transformer.transform(domSource, new StreamResult(outputStream));
    }

    public void updateState(String instanceName, String newState) throws Exception {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xPath = xpf.newXPath();
        Node employee = (Node)xPath.evaluate("/instance-state/instance[@name='" + instanceName + "']/.", this.xmlDoc, XPathConstants.NODE);
        employee.getAttributes().getNamedItem("state").setNodeValue(newState);
        this.writeDoc(new FileOutputStream(this.fileName));
    }

    private Node findNode(String instanceName) {
        NodeList list = this.xmlDoc.getElementsByTagName("instance");
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            String name;
            Node instance = list.item(i);
            NamedNodeMap attrs = instance.getAttributes();
            if (attrs == null || !instanceName.equals(name = this.getNodeValue(attrs.getNamedItem("name")))) continue;
            return instance;
        }
        return null;
    }

    public void addFailedCommand(String instanceName, String failedCmd) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            return;
        }
        Text tNode = this.xmlDoc.createTextNode(failedCmd);
        Element fcNode = this.xmlDoc.createElement("failed-command");
        fcNode.appendChild(tNode);
        instance.appendChild(fcNode);
        this.writeDoc(new FileOutputStream(this.fileName));
    }

    public void removeFailedCommands(String instanceName) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            return;
        }
        NodeList clist = instance.getChildNodes();
        for (int j = 0; j < clist.getLength(); ++j) {
            instance.removeChild(clist.item(j));
        }
        this.writeDoc(new FileOutputStream(this.fileName));
    }

    public void removeInstanceNode(String instanceName) throws Exception {
        Node instance = this.findNode(instanceName);
        if (instance == null) {
            return;
        }
        NodeList clist = instance.getChildNodes();
        for (int j = 0; j < clist.getLength(); ++j) {
            instance.removeChild(clist.item(j));
        }
        Node parent = instance.getParentNode();
        parent.removeChild(instance);
        this.writeDoc(new FileOutputStream(this.fileName));
    }
}

