/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGenerator;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;

public abstract class ResourcesGeneratorBase
implements ResourcesGenerator {
    private Set<String> alreadyGenerated = new HashSet<String>();
    private static final Map<String, String> configBeanToDELETECommand = new HashMap<String, String>(){
        {
            this.put("AmxPref", "GENERIC-DELETE");
            this.put("ApplicationRef", "delete-application-ref");
            this.put("ExternalJndiResource", "delete-jndi-resource");
            this.put("GroupMap", "GENERIC-DELETE");
            this.put("JaccProvider", "delete-jacc-provider");
            this.put("NetworkListener", "delete-network-listener");
            this.put("Principal", "GENERIC-DELETE");
            this.put("PrincipalMap", "GENERIC-DELETE");
            this.put("Profiler", "delete-profiler");
            this.put("Property", "GENERIC-DELETE");
            this.put("Protocol", "delete-protocol");
            this.put("ProtocolFilter", "delete-protocol-filter");
            this.put("ProtocolFinder", "delete-protocol-finder");
            this.put("SecurityMap", "delete-connector-security-map");
            this.put("Transport", "delete-transport");
            this.put("ThreadPool", "delete-threadpool");
            this.put("UserGroup", "GENERIC-DELETE");
            this.put("WorkSecurityMap", "delete-connector-work-security-map");
        }
    };
    private static final Map<String, String> configBeanToPOSTCommand = new HashMap<String, String>(){
        {
            this.put("Application", "redeploy");
            this.put("JavaConfig", "create-profiler");
            this.put("ListAdminObjectResource", "create-admin-object");
            this.put("ListApplication", "deploy");
            this.put("ListApplicationRef", "create-application-ref");
            this.put("ListAuditModule", "create-audit-module");
            this.put("ListAuthRealm", "create-auth-realm");
            this.put("ListCluster", "create-cluster");
            this.put("ListConfig", "create-config");
            this.put("ListConnectorConnectionPool", "create-connector-connection-pool");
            this.put("ListConnectorResource", "create-connector-resource");
            this.put("ListCustomResource", "create-custom-resource");
            this.put("ListExternalJndiResource", "create-jndi-resource");
            this.put("ListHttpListener", "create-http-listener");
            this.put("ListIiopListener", "create-iiop-listener");
            this.put("ListJaccProvider", "create-jacc-provider");
            this.put("ListJdbcConnectionPool", "create-jdbc-connection-pool");
            this.put("ListJdbcResource", "create-jdbc-resource");
            this.put("ListJmsHost", "create-jms-host");
            this.put("ListLbConfig", "create-http-lb-config");
            this.put("ListLoadBalancer", "create-http-lb");
            this.put("ListMailResource", "create-javamail-resource");
            this.put("ListMessageSecurityConfig", "create-message-security-provider");
            this.put("ListNetworkListener", "create-network-listener");
            this.put("ListProtocol", "create-protocol");
            this.put("ListResourceAdapterConfig", "create-resource-adapter-config");
            this.put("ListResourceRef", "create-resource-ref");
            this.put("ListSystemProperty", "create-system-properties");
            this.put("ListThreadPool", "create-threadpool");
            this.put("ListTransport", "create-transport");
            this.put("ListVirtualServer", "create-virtual-server");
            this.put("ListWorkSecurityMap", "create-connector-work-security-map");
            this.put("ProtocolFilter", "create-protocol-filter");
            this.put("ProtocolFinder", "create-protocol-finder");
            this.put("ListSecurityMap", "create-connector-security-map");
        }
    };
    public static final String[][] configBeanCustomResources = new String[][]{{"Cluster", "SystemPropertiesCliResource", "system-properties"}, {"Config", "SystemPropertiesCliResource", "system-properties"}, {"Domain", "JmxServiceUrlsResource", "jmx-urls"}, {"Domain", "LogViewerResource", "view-log"}, {"Domain", "SetDomainConfigResource", "set"}, {"NetworkListener", "FindHttpProtocolResource", "find-http-protocol"}, {"Server", "SystemPropertiesCliResource", "system-properties"}};
    private static final Map<String, CollectionLeafMetaData> configBeanToCollectionLeafMetaData = new HashMap<String, CollectionLeafMetaData>(){
        {
            this.put("JvmOptions", new CollectionLeafMetaData("create-jvm-options", "delete-jvm-options", "JvmOption"));
            this.put("Principal", new CollectionLeafMetaData("__create-principal", "__delete-principal", "Principal"));
            this.put("UserGroup", new CollectionLeafMetaData("__create-user-group", "__delete-user-group", "User Group"));
        }
    };

    public void generateSingle(ConfigModel model, DomDocument domDocument) {
        this.configModelVisited(model);
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = this.getBeanName(serverConfigName);
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        String baseClassName = "TemplateResource";
        String resourcePath = null;
        if (beanName.equals("Domain")) {
            baseClassName = "org.glassfish.admin.rest.resources.GlassFishDomainResource";
            resourcePath = "domain";
        }
        ClassWriter classWriter = this.getClassWriter(className, baseClassName, resourcePath);
        this.generateCommandResources(beanName, classWriter);
        this.generateGetDeleteCommandMethod(beanName, classWriter);
        this.generateCustomResourceMapping(beanName, classWriter);
        for (String elementName : model.getElementNames()) {
            ConfigModel.Property childElement = model.getElement(elementName);
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)childElement;
                ConfigModel childModel = node.getModel();
                List<ConfigModel> subChildConfigModels = ResourceUtil.getRealChildConfigModels(childModel, domDocument);
                for (ConfigModel subChildConfigModel : subChildConfigModels) {
                    if (ResourceUtil.isOnlyATag(childModel)) {
                        String childResourceClassName = this.getClassName(ResourceUtil.getUnqualifiedTypeName(subChildConfigModel.targetTypeName));
                        String childPath = subChildConfigModel.getTagName();
                        classWriter.createGetChildResource(childPath, childResourceClassName);
                        this.generateSingle(subChildConfigModel, domDocument);
                        continue;
                    }
                    this.processNonLeafChildConfigModel(subChildConfigModel, childElement, domDocument, classWriter);
                }
                continue;
            }
            if (childElement.isLeaf()) {
                if (!childElement.isCollection()) continue;
                String childResourceBeanName = this.getBeanName(elementName);
                String childResourceClassName = this.getClassName(childResourceBeanName);
                classWriter.createGetChildResource(elementName, childResourceClassName);
                this.generateCollectionLeafResource(childResourceBeanName);
                continue;
            }
            this.processNonLeafChildElement(elementName, childElement, domDocument, classWriter);
        }
        classWriter.done();
    }

    public void generateList(ConfigModel model, DomDocument domDocument) {
        this.configModelVisited(model);
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = this.getBeanName(serverConfigName);
        String className = "List" + this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "TemplateListOfResource", null);
        String keyAttributeName = this.getKeyAttributeName(model);
        String childResourceClassName = this.getClassName(beanName);
        classWriter.createGetChildResourceForListResources(keyAttributeName, childResourceClassName);
        this.generateCommandResources("List" + beanName, classWriter);
        this.generateGetPostCommandMethod("List" + beanName, classWriter);
        classWriter.done();
        this.generateSingle(model, domDocument);
    }

    public void configModelVisited(ConfigModel model) {
    }

    private void generateCollectionLeafResource(String beanName) {
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "CollectionLeafResource", null);
        CollectionLeafMetaData metaData = configBeanToCollectionLeafMetaData.get(beanName);
        if (metaData != null) {
            if (metaData.postCommandName != null) {
                classWriter.createGetPostCommandForCollectionLeafResource(metaData.postCommandName);
            }
            if (metaData.deleteCommandName != null) {
                classWriter.createGetDeleteCommandForCollectionLeafResource(metaData.deleteCommandName);
            }
            classWriter.createGetDisplayNameForCollectionLeafResource(metaData.displayName);
        }
        classWriter.done();
    }

    private void processNonLeafChildElement(String elementName, ConfigModel.Property childElement, DomDocument domDocument, ClassWriter classWriter) {
        ConfigModel.Node node = (ConfigModel.Node)childElement;
        ConfigModel childModel = node.getModel();
        String beanName = ResourceUtil.getUnqualifiedTypeName(childModel.targetTypeName);
        if (beanName.equals("Property")) {
            classWriter.createGetChildResource("property", "PropertiesBagResource");
        } else {
            String childResourceClassName = this.getClassName(beanName);
            if (childElement.isCollection()) {
                childResourceClassName = "List" + childResourceClassName;
            }
            classWriter.createGetChildResource(childModel.getTagName(), childResourceClassName);
        }
        if (childElement.isCollection()) {
            this.generateList(childModel, domDocument);
        } else {
            this.generateSingle(childModel, domDocument);
        }
    }

    private void processNonLeafChildConfigModel(ConfigModel childConfigModel, ConfigModel.Property childElement, DomDocument domDocument, ClassWriter classWriter) {
        String childResourceClassName = this.getClassName("List" + ResourceUtil.getUnqualifiedTypeName(childConfigModel.targetTypeName));
        String childPath = childConfigModel.getTagName();
        classWriter.createGetChildResource(childPath, childResourceClassName);
        if (childElement.isCollection()) {
            this.generateList(childConfigModel, domDocument);
        }
    }

    private void generateGetDeleteCommandMethod(String beanName, ClassWriter classWriter) {
        String commandName = configBeanToDELETECommand.get(beanName);
        if (commandName != null) {
            classWriter.createGetDeleteCommand(commandName);
        }
    }

    private void generateCustomResourceMapping(String beanName, ClassWriter classWriter) {
        for (int i = 0; i < configBeanCustomResources.length; ++i) {
            String[] row = configBeanCustomResources[i];
            if (!row[0].equals(beanName)) continue;
            classWriter.createCustomResourceMapping(row[1], row[2]);
        }
    }

    void generateGetPostCommandMethod(String resourceName, ClassWriter classWriter) {
        String commandName = configBeanToPOSTCommand.get(resourceName);
        if (commandName != null) {
            classWriter.createGetPostCommand(commandName);
        }
    }

    private void generateCommandResources(String parentBeanName, ClassWriter parentWriter) {
        List<CommandResourceMetaData> commandMetaData = CommandResourceMetaData.getMetaData(parentBeanName);
        if (commandMetaData.size() > 0) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                String commandResourceName = parentBeanName + this.getBeanName(metaData.resourcePath);
                String commandResourceClassName = this.getClassName(commandResourceName);
                this.generateCommandResourceClass(parentBeanName, metaData);
                parentWriter.createGetCommandResource(commandResourceClassName, metaData.resourcePath);
            }
            parentWriter.createGetCommandResourcePaths(commandMetaData);
        }
    }

    private void generateCommandResourceClass(String parentBeanName, CommandResourceMetaData metaData) {
        String baseClassName;
        String commandResourceClassName = this.getClassName(parentBeanName + this.getBeanName(metaData.resourcePath));
        String commandName = metaData.command;
        String commandDisplayName = metaData.resourcePath;
        String httpMethod = metaData.httpMethod;
        String commandAction = metaData.displayName;
        if (httpMethod.equals("GET")) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandGetResource";
        } else if (httpMethod.equals("DELETE")) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandDeleteResource";
        } else if (httpMethod.equals("POST")) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandPostResource";
        } else {
            throw new GeneratorException("Invalid httpMethod specified: " + httpMethod);
        }
        ClassWriter writer = this.getClassWriter(commandResourceClassName, baseClassName, null);
        boolean isLinkedToParent = false;
        if (metaData.commandParams != null) {
            for (CommandResourceMetaData.ParameterMetaData parameterMeraData : metaData.commandParams) {
                if (!"$parent".equals(parameterMeraData.value)) continue;
                isLinkedToParent = true;
            }
        }
        writer.createCommandResourceConstructor(commandResourceClassName, commandName, httpMethod, isLinkedToParent, metaData.commandParams, commandDisplayName, commandAction);
        writer.done();
    }

    private boolean alreadyGenerated(String className) {
        boolean retVal = true;
        if (!this.alreadyGenerated.contains(className)) {
            this.alreadyGenerated.add(className);
            retVal = false;
        }
        return retVal;
    }

    private String getClassName(String beanName) {
        return beanName + "Resource";
    }

    private String getBeanName(String elementName) {
        String ret = "";
        boolean nextisUpper = true;
        for (int i = 0; i < elementName.length(); ++i) {
            if (nextisUpper) {
                ret = ret + elementName.substring(i, i + 1).toUpperCase();
                nextisUpper = false;
                continue;
            }
            if (elementName.charAt(i) == '-') {
                nextisUpper = true;
                continue;
            }
            nextisUpper = false;
            ret = ret + elementName.substring(i, i + 1);
        }
        return ret;
    }

    private String getKeyAttributeName(ConfigModel model) {
        String keyAttributeName = null;
        if (model.key == null) {
            for (String s : model.getAttributeNames()) {
                if (!s.equals("name")) continue;
                keyAttributeName = this.getBeanName(s);
            }
            if (keyAttributeName == null) {
                Set<String> attributeNames = model.getAttributeNames();
                keyAttributeName = !attributeNames.isEmpty() ? this.getBeanName(attributeNames.iterator().next()) : "ThisIsAModelBug:NoKeyAttr";
            }
        } else {
            keyAttributeName = this.getBeanName(model.key.substring(1, model.key.length()));
        }
        return keyAttributeName;
    }

    private void processRedirectsAnnotation(ConfigModel model) {
        Class<?> cbp = null;
        try {
            cbp = model.classLoaderHolder.get().loadClass(model.targetTypeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
        if (restRedirects != null) {
            RestRedirect[] values;
            for (RestRedirect r : values = restRedirects.value()) {
                System.out.println(r.commandName());
                System.out.println(r.opType());
            }
        }
    }

    private static class CollectionLeafMetaData {
        String postCommandName;
        String deleteCommandName;
        String displayName;

        CollectionLeafMetaData(String postCommandName, String deleteCommandName, String displayName) {
            this.postCommandName = postCommandName;
            this.deleteCommandName = deleteCommandName;
            this.displayName = displayName;
        }
    }
}

