/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import com.sun.jersey.api.core.ResourceContext;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.admin.rest.logviewer.LogRecord;
import org.glassfish.admin.rest.resources.custom.LogNamesResource;
import org.glassfish.internal.api.LogManager;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredLogViewerResource {
    @Context
    protected Habitat habitat;
    @Context
    protected ResourceContext resourceContext;

    @Path(value="lognames/")
    public LogNamesResource getLogNamesResource() {
        LogNamesResource resource = (LogNamesResource)this.resourceContext.getResource(LogNamesResource.class);
        return resource;
    }

    @GET
    @Produces(value={"text/plain", "application/json"})
    public String getJson(@QueryParam(value="logFileName") @DefaultValue(value="${com.sun.aas.instanceRoot}/logs/server.log") String logFileName, @QueryParam(value="startIndex") @DefaultValue(value="-1") long startIndex, @QueryParam(value="searchForward") @DefaultValue(value="false") boolean searchForward, @QueryParam(value="maximumNumberOfResults") @DefaultValue(value="40") int maximumNumberOfResults, @QueryParam(value="onlyLevel") @DefaultValue(value="false") boolean onlyLevel, @QueryParam(value="fromTime") @DefaultValue(value="-1") long fromTime, @QueryParam(value="toTime") @DefaultValue(value="-1") long toTime, @QueryParam(value="logLevel") @DefaultValue(value="INFO") String logLevel, @QueryParam(value="anySearch") @DefaultValue(value="") String anySearch, @QueryParam(value="listOfModules") List<String> listOfModules, @QueryParam(value="instanceName") @DefaultValue(value="") String instanceName, @QueryParam(value="logFileRefresh") @DefaultValue(value="false") boolean logFileRefresh) throws IOException {
        return this.getWithType(logFileName, startIndex, searchForward, maximumNumberOfResults, fromTime, toTime, logLevel, onlyLevel, anySearch, listOfModules, instanceName, "json", logFileRefresh);
    }

    @GET
    @Produces(value={"application/xml"})
    public String getXML(@QueryParam(value="logFileName") @DefaultValue(value="${com.sun.aas.instanceRoot}/logs/server.log") String logFileName, @QueryParam(value="startIndex") @DefaultValue(value="-1") long startIndex, @QueryParam(value="searchForward") @DefaultValue(value="false") boolean searchForward, @QueryParam(value="maximumNumberOfResults") @DefaultValue(value="40") int maximumNumberOfResults, @QueryParam(value="onlyLevel") @DefaultValue(value="true") boolean onlyLevel, @QueryParam(value="fromTime") @DefaultValue(value="-1") long fromTime, @QueryParam(value="toTime") @DefaultValue(value="-1") long toTime, @QueryParam(value="logLevel") @DefaultValue(value="INFO") String logLevel, @QueryParam(value="anySearch") @DefaultValue(value="") String anySearch, @QueryParam(value="listOfModules") List<String> listOfModules, @QueryParam(value="instanceName") @DefaultValue(value="") String instanceName, @QueryParam(value="logFileRefresh") @DefaultValue(value="false") boolean logFileRefresh) throws IOException {
        return this.getWithType(logFileName, startIndex, searchForward, maximumNumberOfResults, fromTime, toTime, logLevel, onlyLevel, anySearch, listOfModules, instanceName, "xml", logFileRefresh);
    }

    private String getWithType(String logFileName, long startIndex, boolean searchForward, int maximumNumberOfResults, long fromTime, long toTime, String logLevel, boolean onlyLevel, String anySearch, List<String> listOfModules, String instanceName, String type, boolean logFileRefresh) throws IOException {
        if (this.habitat.getComponent(LogManager.class) == null) {
            throw new IOException("The GlassFish LogManager Service is not available. Not installed?");
        }
        Properties nameValueMap = new Properties();
        boolean sortAscending = true;
        if (!searchForward) {
            sortAscending = false;
        }
        LogFilter logFilter = this.habitat.getComponent(LogFilter.class);
        if (instanceName.equals("")) {
            AttributeList result = logFilter.getLogRecordsUsingQuery(logFileName, Long.valueOf(startIndex), Boolean.valueOf(searchForward), Boolean.valueOf(sortAscending), Integer.valueOf(maximumNumberOfResults), fromTime == -1L ? null : new Date(fromTime), toTime == -1L ? null : new Date(toTime), logLevel, Boolean.valueOf(onlyLevel), listOfModules, nameValueMap, anySearch);
            return this.convertQueryResult(result, type);
        }
        AttributeList result = logFilter.getLogRecordsUsingQuery(logFileName, Long.valueOf(startIndex), Boolean.valueOf(searchForward), Boolean.valueOf(sortAscending), Integer.valueOf(maximumNumberOfResults), fromTime == -1L ? null : new Date(fromTime), toTime == -1L ? null : new Date(toTime), logLevel, Boolean.valueOf(onlyLevel), listOfModules, nameValueMap, anySearch, instanceName, logFileRefresh);
        return this.convertQueryResult(result, type);
    }

    private <T> List<T> asList(Object list) {
        return (List)List.class.cast(list);
    }

    private String quoted(String s) {
        return "\"" + s + "\"";
    }

    private String convertQueryResult(AttributeList queryResult, String type) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (type.equals("json")) {
            sb.append("{\"records\": [");
        } else {
            sb.append("<records>\n");
        }
        if (queryResult.size() > 0) {
            AttributeList fieldAttrs = (AttributeList)((Attribute)queryResult.get(0)).getValue();
            String[] fieldHeaders = new String[fieldAttrs.size()];
            for (int i = 0; i < fieldHeaders.length; ++i) {
                Attribute attr = (Attribute)fieldAttrs.get(i);
                fieldHeaders[i] = (String)attr.getValue();
            }
            List srcRecords = this.asList(((Attribute)queryResult.get(1)).getValue());
            for (int recordIdx = 0; recordIdx < srcRecords.size(); ++recordIdx) {
                List record = (List)srcRecords.get(recordIdx);
                assert (record.size() == fieldHeaders.length);
                LogRecord rec = new LogRecord();
                int fieldIdx = 0;
                rec.setRecordNumber((Long)record.get(fieldIdx++));
                rec.setLoggedDateTime((Date)record.get(fieldIdx++));
                rec.setLoggedLevel((String)record.get(fieldIdx++));
                rec.setProductName((String)record.get(fieldIdx++));
                rec.setLoggerName((String)record.get(fieldIdx++));
                rec.setNameValuePairs((String)record.get(fieldIdx++));
                rec.setMessageID((String)record.get(fieldIdx++));
                rec.setMessage((String)record.get(fieldIdx++));
                if (type.equals("json")) {
                    sb.append(sep);
                    sb.append(rec.toJSON());
                    sep = ",";
                    continue;
                }
                sb.append(rec.toXML());
            }
        }
        if (type.equals("json")) {
            sb.append("]}\n");
        } else {
            sb.append("\n</records>\n");
        }
        return sb.toString();
    }
}

