/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.logging.LogDomains;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.gms.admin.GMSAnnounceSupplementalInfo;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_gmsAnnounceAfterStartClusterCommand")
@Supplemental(value="start-cluster", on=Supplemental.Timing.After, ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
public class GMSAnnounceAfterStartClusterCommand
implements AdminCommand {
    private static final Logger logger = LogDomains.getLogger(GMSAnnounceAfterStartClusterCommand.class, (String)"javax.org.glassfish.gms");
    @Inject
    private ServerEnvironment env;
    @Inject
    private Habitat habitat;
    @Param(optional=false, primary=true)
    private String clusterName;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Inject
    GMSAdapterService gmsAdapterService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        GMSAnnounceAfterStartClusterCommand.announceGMSGroupStartupComplete(this.clusterName, report);
    }

    public static void announceGMSGroupStartupComplete(String clusterName, ActionReport report) {
        GMSAnnounceSupplementalInfo gmsInfo;
        if (report != null && (gmsInfo = (GMSAnnounceSupplementalInfo)report.getResultType(GMSAnnounceSupplementalInfo.class)) != null && gmsInfo.gmsInitiated) {
            LinkedList members = null;
            GMSConstants.groupStartupState groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_FAILED;
            logger.log(Level.INFO, "after.start", new Object[]{report.getActionExitCode(), members, gmsInfo.clusterMembers});
            switch (report.getActionExitCode()) {
                case SUCCESS: {
                    members = gmsInfo.clusterMembers;
                    groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_SUCCESS;
                    break;
                }
                case FAILURE: {
                    members = gmsInfo.clusterMembers;
                    groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_FAILED;
                    break;
                }
                case WARNING: {
                    members = (LinkedList)report.getResultType(List.class);
                    groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_FAILED;
                    break;
                }
            }
            try {
                if (gmsInfo.gms != null) {
                    if (members == null) {
                        members = new LinkedList();
                    }
                    gmsInfo.gms.announceGroupStartup(clusterName, groupStartupState2, members);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "group.start.exception", t.getLocalizedMessage());
            }
        }
    }
}

