/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.glassfish.embeddable.BootstrapOptions;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishOptions;
import org.glassfish.embeddable.spi.RuntimeBuilder;

public abstract class GlassFishRuntime {
    private static GlassFishRuntime me;
    private static RuntimeBuilder runtimeBuilder;

    public static synchronized GlassFishRuntime bootstrap(BootstrapOptions options, ClassLoader cl) throws GlassFishException {
        if (me != null) {
            return me;
        }
        runtimeBuilder = GlassFishRuntime.getRuntimeBuilder(options, cl != null ? cl : GlassFishRuntime.class.getClassLoader());
        me = runtimeBuilder.build(options);
        return me;
    }

    public synchronized void shutdown() throws GlassFishException {
        this.disposeGlassFishInstances();
        try {
            runtimeBuilder.destroy();
            me = null;
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    public static synchronized GlassFishRuntime get() {
        if (me == null) {
            throw new RuntimeException("Not yet bootstrapped");
        }
        return me;
    }

    public abstract GlassFish newGlassFish(GlassFishOptions var1) throws GlassFishException;

    protected abstract void disposeGlassFishInstances();

    private static RuntimeBuilder getRuntimeBuilder(BootstrapOptions options, ClassLoader cl) {
        Iterator<RuntimeBuilder> runtimeBuilders = ServiceLoader.load(RuntimeBuilder.class, cl).iterator();
        while (runtimeBuilders.hasNext()) {
            try {
                RuntimeBuilder builder = runtimeBuilders.next();
                if (!builder.handles(options)) continue;
                return builder;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        throw new RuntimeException("No runtime builder for this configuration: " + options.getAllOptions());
    }
}

