/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.jboss.weld.bean.proxy.util.SerializableProxy;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ProxyServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProxyServices
implements ProxyServices {
    @Override
    public ClassLoader getClassLoader(final Class<?> type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return SimpleProxyServices.this._getClassLoader(type);
                }
            });
        }
        return this._getClassLoader(type);
    }

    private ClassLoader _getClassLoader(Class<?> type) {
        if (type.getName().startsWith("java")) {
            return this.getClass().getClassLoader();
        }
        return type.getClassLoader();
    }

    @Override
    public ProtectionDomain getProtectionDomain(Class<?> type) {
        if (type.getName().startsWith("java")) {
            return this.getClass().getProtectionDomain();
        }
        return type.getProtectionDomain();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public Object wrapForSerialization(Object proxyObject) {
        return new SerializableProxy(proxyObject);
    }

    @Override
    public Class<?> loadBeanClass(final String className) {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader cl = SimpleProxyServices.this.getClassLoader(this.getClass());
                    return Class.forName(className, true, cl);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new WeldException(BeanMessage.CANNOT_LOAD_CLASS, className, pae.getException());
        }
    }
}

