/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManagers {
    private BeanManagers() {
    }

    public static Set<Iterable<BeanManagerImpl>> getAccessibleClosure(BeanManagerImpl beanManager) {
        HashSet<Iterable<BeanManagerImpl>> beanManagers = new HashSet<Iterable<BeanManagerImpl>>();
        beanManagers.add(Collections.singleton(beanManager));
        beanManagers.addAll(BeanManagers.buildAccessibleClosure(beanManager, new HashSet<BeanManagerImpl>(), BeanManagerTransform.INSTANCE));
        return beanManagers;
    }

    public static <T> Set<Iterable<T>> buildAccessibleClosure(BeanManagerImpl beanManager, Collection<BeanManagerImpl> hierarchy, Transform<T> transform) {
        HashSet<Iterable<T>> result = new HashSet<Iterable<T>>();
        hierarchy.add(beanManager);
        result.add(transform.transform(beanManager));
        for (BeanManagerImpl accessibleBeanManager : beanManager.getAccessibleManagers()) {
            if (hierarchy.contains(accessibleBeanManager)) continue;
            result.addAll(BeanManagers.buildAccessibleClosure(accessibleBeanManager, new ArrayList<BeanManagerImpl>(hierarchy), transform));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanManagerTransform
    implements Transform<BeanManagerImpl> {
        public static final BeanManagerTransform INSTANCE = new BeanManagerTransform();

        private BeanManagerTransform() {
        }

        @Override
        public Iterable<BeanManagerImpl> transform(BeanManagerImpl beanManager) {
            return beanManager.getAccessibleManagers();
        }
    }
}

