/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-instance")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="restart.instance.command")
@ExecuteOn(value={RuntimeType.DAS})
public class RestartInstanceCommand
implements AdminCommand {
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment env;
    @Param(optional=false, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private String errorMessage = null;

    public void execute(AdminCommandContext context) {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.errorMessage = this.env.isDas() ? this.callInstance() : Strings.get("restart.instance.notDas", this.env.getRuntimeType().toString());
        if (this.errorMessage != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(this.errorMessage);
            return;
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.report.setMessage(Strings.get("restart.instance.success", this.instanceName));
    }

    private String callInstance() {
        String cmdName = "restart-instance";
        if (!StringUtils.ok((String)this.instanceName)) {
            return Strings.get("stop.instance.noInstanceName", cmdName);
        }
        Server instance = this.helper.getServer(this.instanceName);
        if (instance == null) {
            return Strings.get("stop.instance.noSuchInstance", this.instanceName);
        }
        String host = instance.getAdminHost();
        if (host == null) {
            return Strings.get("stop.instance.noHost", this.instanceName);
        }
        int port = this.helper.getAdminPort(instance);
        if (port < 0) {
            return Strings.get("stop.instance.noPort", this.instanceName);
        }
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("_restart-instance", host, port, false, "admin", null, this.logger);
            rac.executeCommand(new ParameterMap());
        }
        catch (CommandException ex) {
            return Strings.get("restart.instance.racError", this.instanceName, ex.getLocalizedMessage());
        }
        return null;
    }
}

