/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="configure-lb-weight")
@Scoped(value=PerLookup.class)
@I18n(value="configure.lb.weight")
@ExecuteOn(value={RuntimeType.DAS})
public final class ConfigureLBWeightCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(optional=false)
    String cluster;
    @Param(primary=true)
    String weights;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigureLBWeightCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Map<String, Integer> instanceWeights = null;
        try {
            instanceWeights = this.getInstanceWeightsMap(this.weights);
        }
        catch (CommandException ce) {
            report.setMessage(localStrings.getLocalString("InvalidWeightValue", "Invalid weight value"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ce);
            return;
        }
        Cluster cl = this.domain.getClusterNamed(this.cluster);
        if (cl == null) {
            String msg = localStrings.getLocalString("NoSuchCluster", "No such cluster {0}", new Object[]{this.cluster});
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        for (String instance : instanceWeights.keySet()) {
            try {
                Server s = this.domain.getServerNamed(instance);
                if (s == null) {
                    String msg = localStrings.getLocalString("NoSuchInstance", "No such instance {0}", new Object[]{instance});
                    logger.warning(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                Cluster c = this.domain.getClusterForInstance(s.getName());
                if (c == null) {
                    String msg = localStrings.getLocalString("InstanceDoesNotBelongToCluster", "Instance {0} does not belong to cluster {1}.", new Object[]{instance, this.cluster});
                    logger.warning(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                if (!c.getName().equals(this.cluster)) {
                    String msg = localStrings.getLocalString("InstanceDoesNotBelongToCluster", "Instance {0} does not belong to cluster {1}.", new Object[]{instance, this.cluster});
                    logger.warning(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    return;
                }
                this.updateLBWeight(s, instanceWeights.get(instance).toString());
            }
            catch (TransactionFailure ex) {
                report.setMessage(ex.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                return;
            }
        }
    }

    private void updateLBWeight(Server s, final String w) throws TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode<Server>(){

            @Override
            public Object run(Server param) throws PropertyVetoException, TransactionFailure {
                param.setLbWeight(w);
                return Boolean.TRUE;
            }
        }, s);
    }
}

