/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Server;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.glassfish.ejb.embedded.DeploymentElement;
import org.glassfish.ejb.embedded.DomainXmlTransformer;
import org.glassfish.ejb.embedded.EJBContainerImpl;
import org.glassfish.ejb.embedded.EjbBuilder;
import org.glassfish.ejb.embedded.EmbeddedEjbContainer;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerProviderImpl
implements EJBContainerProvider {
    static final String KEEP_TEMPORARY_FILES = "org.glassfish.ejb.embedded.keep-temporary-files";
    private static final String GF_PROVIDER_NAME = EJBContainerProviderImpl.class.getName();
    private static final String GF_INSTALLATION_ROOT = "org.glassfish.ejb.embedded.glassfish.installation.root";
    private static final String GF_INSTANCE_ROOT = "org.glassfish.ejb.embedded.glassfish.instance.root";
    private static final String GF_DOMAIN_FILE = "org.glassfish.ejb.embedded.glassfish.configuration.file";
    private static final String GF_INSTANCE_REUSE = "org.glassfish.ejb.embedded.glassfish.instance.reuse";
    private static final Attributes.Name ATTRIBUTE_NAME_SKIP = new Attributes.Name("Bundle-SymbolicName");
    private static final String[] ATTRIBUTE_VALUES_SKIP = new String[]{"org.glassfish.", "com.sun.enterprise.", "org.eclipse."};
    private static final String[] ATTRIBUTE_VALUES_OK = new String[]{"sample", "test"};
    static final String GF_WEB_HTTP_PORT = "org.glassfish.ejb.embedded.glassfish.web.http.port";
    private static final Logger _logger = LogDomains.getLogger(EJBContainerProviderImpl.class, (String)"javax.enterprise.system.container.ejb");
    private static final StringManager localStrings = StringManager.getManager(EJBContainerProviderImpl.class);
    private static final Object lock = new Object();
    private static EJBContainerImpl container;
    private static Server server;
    private static Habitat habitat;
    private static ArchiveFactory archiveFactory;
    private static Class[] ejbAnnotations;

    @Override
    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null || properties.get("javax.ejb.embeddable.provider") == null || properties.get("javax.ejb.embeddable.provider").equals(GF_PROVIDER_NAME)) {
            if (container != null && container.isOpen()) {
                throw new EJBException(localStrings.getString("ejb.embedded.exception_exists_container"));
            }
            this.init(properties);
            try {
                Set<DeploymentElement> modules = this.addModules(properties);
                if (!DeploymentElement.hasEJBModule(modules)) {
                    _logger.log(Level.SEVERE, "ejb.embedded.no_modules_found");
                } else {
                    container.deploy(properties, modules);
                }
                return container;
            }
            catch (Throwable t) {
                if (container != null) {
                    try {
                        _logger.info("[EJBContainerProviderImpl] Cleaning up on failure ...");
                        container.close();
                    }
                    catch (Throwable t1) {
                        _logger.info("[EJBContainerProviderImpl] Error cleaning up..." + t1);
                    }
                }
                _logger.log(Level.SEVERE, "ejb.embedded.exception_instantiating", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Map<?, ?> properties) throws EJBException {
        Object object = lock;
        synchronized (object) {
            Server.Builder builder = new Server.Builder("GFEJBContainerProviderImpl");
            Result rs = this.getLocations(properties);
            if (rs == null) {
                server = builder.build();
                this.addWebContainerIfRequested(properties);
            } else {
                EmbeddedFileSystem.Builder efsb = new EmbeddedFileSystem.Builder();
                if (rs.reuse_instance_location) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("[EJBContainerProviderImpl] Reusing instance location at: " + rs.instance_root);
                    }
                    efsb.instanceRoot(rs.instance_root);
                } else {
                    efsb.configurationFile(rs.domain_file);
                }
                efsb.installRoot(rs.installed_root, true);
                builder.embeddedFileSystem(efsb.build());
                server = builder.build();
            }
            EjbBuilder ejb = (EjbBuilder)server.createConfig(EjbBuilder.class);
            EmbeddedEjbContainer ejbContainer = (EmbeddedEjbContainer)server.addContainer((ContainerBuilder)ejb);
            server.addContainer(ContainerBuilder.Type.jpa);
            habitat = ejb.habitat;
            try {
                EmbeddedSecurity es;
                if (rs != null && !rs.reuse_instance_location && (es = (EmbeddedSecurity)habitat.getByContract(EmbeddedSecurity.class)) != null) {
                    es.copyConfigFiles(habitat, rs.instance_root, rs.domain_file);
                }
                server.start();
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
            EmbeddedDeployer deployer = server.getDeployer();
            Sniffer sniffer = (Sniffer)habitat.getComponent(Sniffer.class, "Ejb");
            ejbAnnotations = sniffer.getAnnotationTypes();
            archiveFactory = (ArchiveFactory)habitat.getComponent(ArchiveFactory.class);
            container = new EJBContainerImpl(habitat, server, ejbContainer, deployer);
        }
    }

    private Set<DeploymentElement> addModules(Map<?, ?> properties) {
        HashSet<DeploymentElement> modules = new HashSet<DeploymentElement>();
        Object obj = properties == null ? null : properties.get("javax.ejb.embeddable.modules");
        HashMap<String, Boolean> moduleNames = new HashMap<String, Boolean>();
        if (obj != null) {
            Object[] arr;
            if (obj instanceof String) {
                moduleNames.put(obj, false);
            } else if (obj instanceof String[]) {
                arr = obj;
                for (Object s : arr) {
                    moduleNames.put((String)s, false);
                }
            } else if (obj instanceof File) {
                this.addModule(modules, moduleNames, obj);
            } else if (obj instanceof File[]) {
                arr = obj;
                for (Object f : arr) {
                    this.addModule(modules, moduleNames, (File)f);
                }
            }
        }
        if (modules.isEmpty()) {
            String[] entries;
            String path = System.getProperty("java.class.path");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerProviderImpl] Looking for EJB modules in classpath: " + path);
            }
            for (String s0 : entries = path.split(File.pathSeparator)) {
                this.addModule(modules, moduleNames, new File(s0));
            }
            if (!moduleNames.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (String mn : moduleNames.keySet()) {
                    if (((Boolean)moduleNames.get(mn)).booleanValue()) continue;
                    sb.append(mn).append(", ");
                }
                int l = sb.length();
                if (l > 0) {
                    throw new EJBException("Modules: [" + sb.substring(0, l - 2) + "] do not match an entry in the classpath");
                }
            }
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentElement getRequestedEJBModuleOrLibrary(File file, Map<String, Boolean> moduleNames) throws Exception {
        DeploymentElement deploymentElement;
        InputStream is;
        block12: {
            DeploymentElement result = null;
            String fileName = file.getName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("... Testing ... " + fileName);
            }
            ReadableArchive archive = null;
            is = null;
            try {
                boolean isEJBModule = false;
                String moduleName = DeploymentUtils.getDefaultEEName((String)fileName);
                archive = archiveFactory.openArchive(file);
                is = this.getDeploymentDescriptor(archive);
                if (is != null) {
                    isEJBModule = true;
                    EjbDeploymentDescriptorFile eddf = new EjbDeploymentDescriptorFile();
                    eddf.setXMLValidation(false);
                    EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)eddf.read(is);
                    ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
                    moduleDesc.setArchiveUri(fileName);
                    moduleName = moduleDesc.getModuleName();
                } else {
                    GenericAnnotationDetector detector = new GenericAnnotationDetector(ejbAnnotations);
                    isEJBModule = detector.hasAnnotationInArchive(archive);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("... is EJB module: " + isEJBModule);
                    if (isEJBModule) {
                        _logger.fine("... is Requested EJB module [" + moduleName + "]: " + (moduleNames.isEmpty() || moduleNames.containsKey(moduleName)));
                    }
                }
                if (!isEJBModule || moduleNames.isEmpty()) {
                    result = new DeploymentElement(file, isEJBModule);
                } else if (moduleNames.containsKey(moduleName) && !moduleNames.get(moduleName).booleanValue()) {
                    result = new DeploymentElement(file, isEJBModule);
                    moduleNames.put(moduleName, true);
                }
                deploymentElement = result;
                Object var13_12 = null;
                if (archive == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var13_13 = null;
                    if (archive != null) {
                        archive.close();
                    }
                    if (is == null) break block13;
                    is.close();
                }
                throw throwable;
            }
            archive.close();
        }
        if (is != null) {
            is.close();
        }
        return deploymentElement;
    }

    private void addModule(Set<DeploymentElement> modules, Map<String, Boolean> moduleNames, File f) {
        try {
            DeploymentElement de;
            if (f.exists() && !this.skipJar(f) && (de = this.getRequestedEJBModuleOrLibrary(f, moduleNames)) != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("... Added " + (de.isEJBModule() ? "EJB Module" : "library") + " .... " + de.getElement().getName());
                }
                modules.add(de);
            }
        }
        catch (Exception ioe) {
            _logger.log(Level.FINE, "ejb.embedded.io_exception", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean skipJar(File file) throws Exception {
        if (!file.isFile()) {
            return false;
        }
        jf = null;
        try {
            jf = new JarFile(file);
            m = jf.getManifest();
            if (m != null && (value = (attributes = m.getMainAttributes()).getValue(EJBContainerProviderImpl.ATTRIBUTE_NAME_SKIP)) != null) {
                for (String skipValue : EJBContainerProviderImpl.ATTRIBUTE_VALUES_SKIP) {
                    if (!value.startsWith(skipValue)) continue;
                    for (String okValue : EJBContainerProviderImpl.ATTRIBUTE_VALUES_OK) {
                        if (value.indexOf(okValue) <= 0) continue;
                        var14_15 = false;
                        var16_16 = null;
                        if (jf == null) return var14_15;
                        try {
                            jf.close();
                            return var14_15;
                        }
                        catch (IOException ex) {
                            EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                        }
                        return var14_15;
                    }
                    EJBContainerProviderImpl._logger.info("... skipping... " + file.getName());
                    var10_11 = true;
                    var16_17 = null;
                    if (jf == null) return var10_11;
                    ** try [egrp 1[TRYBLOCK] [4 : 202->209)] { 
lbl28:
                    // 1 sources

                    jf.close();
                    return var10_11;
lbl30:
                    // 1 sources

                    catch (IOException ex) {
                        EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
                    }
                    return var10_11;
                }
            }
        }
        catch (Throwable var15_24) {
            var16_19 = null;
            if (jf == null) throw var15_24;
            ** try [egrp 1[TRYBLOCK] [4 : 202->209)] { 
lbl39:
            // 1 sources

            jf.close();
            throw var15_24;
lbl41:
            // 1 sources

            catch (IOException ex) {
                EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
            }
            throw var15_24;
        }
        var16_18 = null;
        if (jf == null) return false;
        try {}
        catch (IOException ex) {
            EJBContainerProviderImpl._logger.log(Level.FINE, "Exception while closing JarFile " + jf.getName() + ": ", ex);
            return false;
        }
        jf.close();
        return false;
    }

    private File getValidFile(String location) {
        File f = new File(location);
        if (!f.exists()) {
            _logger.log(Level.SEVERE, "ejb.embedded.location_not_exists", location);
            f = null;
        }
        return f;
    }

    private Result getLocations(Map<?, ?> properties) throws EJBException {
        File installed_root;
        Result rs = null;
        String installed_root_location = null;
        String instance_root_location = null;
        String domain_file_location = null;
        boolean reuse_instance_location = false;
        if (properties != null) {
            installed_root_location = (String)properties.get(GF_INSTALLATION_ROOT);
            instance_root_location = (String)properties.get(GF_INSTANCE_ROOT);
            domain_file_location = (String)properties.get(GF_DOMAIN_FILE);
            Object value = properties.get(GF_INSTANCE_REUSE);
            if (value != null) {
                if (value instanceof String) {
                    reuse_instance_location = Boolean.valueOf((String)value);
                } else {
                    try {
                        reuse_instance_location = (Boolean)value;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        if (installed_root_location == null) {
            try {
                installed_root_location = Which.jarFile(this.getClass()).getParentFile().getParentFile().getAbsolutePath();
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "ejb.embedded.cannot_determine_installation_location");
                _logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[EJBContainerProviderImpl] installed_root_location : " + installed_root_location);
        }
        if (installed_root_location != null && (installed_root = this.getValidFile(installed_root_location)) != null) {
            File instance_root;
            if (instance_root_location == null) {
                instance_root_location = installed_root_location + File.separatorChar + "domains" + File.separatorChar + "domain1";
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[EJBContainerProviderImpl] instance_root_location: " + instance_root_location);
            }
            if ((instance_root = this.getValidFile(instance_root_location)) != null) {
                File domain_file;
                if (domain_file_location == null) {
                    domain_file_location = instance_root_location + File.separatorChar + "config" + File.separatorChar + "domain.xml";
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("[EJBContainerProviderImpl] domain_file_location : " + domain_file_location);
                }
                if ((domain_file = this.getValidFile(domain_file_location)) != null) {
                    if (!reuse_instance_location) {
                        File temp_domain_file = null;
                        try {
                            DomainXmlTransformer dxf = new DomainXmlTransformer(domain_file, _logger);
                            boolean keep_ports = properties == null ? false : properties.get(GF_WEB_HTTP_PORT) != null;
                            temp_domain_file = dxf.transform(keep_ports);
                        }
                        catch (Exception e) {
                            throw new EJBException(localStrings.getString("ejb.embedded.exception_creating_temporary_domain_xml_file"), e);
                        }
                        if (temp_domain_file != null) {
                            domain_file = temp_domain_file;
                        } else {
                            throw new EJBException(localStrings.getString("ejb.embedded.failed_create_temporary_domain_xml_file"));
                        }
                    }
                    rs = new Result(installed_root, instance_root, domain_file, reuse_instance_location);
                }
            }
        }
        return rs;
    }

    private InputStream getDeploymentDescriptor(ReadableArchive archive) throws IOException {
        InputStream dd = archive.getEntry("META-INF/ejb-jar.xml");
        if (dd == null) {
            dd = archive.getEntry("WEB-INF/ejb-jar.xml");
        }
        return dd;
    }

    private void addWebContainerIfRequested(Map<?, ?> properties) throws EJBException {
        String http_port;
        String string = http_port = properties == null ? null : (String)properties.get(GF_WEB_HTTP_PORT);
        if (http_port != null) {
            int port = 8080;
            try {
                port = Integer.valueOf(http_port);
            }
            catch (NumberFormatException e) {
                System.err.println("Using port 8080");
            }
            try {
                Port http = server.createPort(port);
                ContainerBuilder cb = server.createConfig(ContainerBuilder.Type.web);
                EmbeddedContainer container = server.addContainer(cb);
                container.bind(http, "http");
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    static {
        ejbAnnotations = null;
    }

    private class Result {
        final File installed_root;
        final File instance_root;
        final File domain_file;
        final boolean reuse_instance_location;

        Result(File installed_root, File instance_root, File domain_file, boolean reuse_instance_location) {
            this.installed_root = installed_root;
            this.instance_root = instance_root;
            this.domain_file = domain_file;
            this.reuse_instance_location = reuse_instance_location;
        }
    }
}

