/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-transport")
@Scoped(value=PerLookup.class)
@I18n(value="create.transport")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateTransport
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateTransport.class);
    @Param(name="transportname", primary=true)
    String transportName;
    @Param(name="acceptorthreads", alias="acceptorThreads", optional=true, defaultValue="-1")
    String acceptorThreads;
    @Param(name="buffersizebytes", alias="bufferSizeBytes", optional=true, defaultValue="8192")
    String bufferSizeBytes;
    @Param(name="bytebuffertype", alias="byteBufferType", optional=true, defaultValue="HEAP")
    String byteBufferType;
    @Param(name="classname", optional=true, defaultValue="com.sun.grizzly.TCPSelectorHandler")
    String className;
    @Param(name="displayconfiguration", alias="displayConfiguration", optional=true, defaultValue="false")
    Boolean displayConfiguration;
    @Param(name="enablesnoop", alias="enableSnoop", optional=true, defaultValue="false")
    Boolean enableSnoop;
    @Param(name="idlekeytimeoutseconds", alias="idleKeyTimeoutSeconds", optional=true, defaultValue="30")
    String idleKeyTimeoutSeconds;
    @Param(name="maxconnectionscount", alias="maxConnectionsCount", optional=true, defaultValue="4096")
    String maxConnectionsCount;
    @Param(name="readtimeoutmillis", alias="readTimeoutMillis", optional=true, defaultValue="30000")
    String readTimeoutMillis;
    @Param(name="writetimeoutmillis", alias="writeTimeoutMillis", optional=true, defaultValue="30000")
    String writeTimeoutMillis;
    @Param(name="selectionkeyhandler", alias="selectionKeyHandler", optional=true)
    String selectionKeyHandler;
    @Param(name="selectorpolltimeoutmillis", alias="selectorPollTimeoutMillis", optional=true, defaultValue="1000")
    String selectorPollTimeoutMillis;
    @Param(name="tcpnodelay", alias="tcpNoDelay", optional=true, defaultValue="false")
    Boolean tcpNoDelay;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Transports transports = networkConfig.getTransports();
        for (Transport transport : transports.getTransport()) {
            if (this.transportName == null || !this.transportName.equalsIgnoreCase(transport.getName())) continue;
            report.setMessage(localStrings.getLocalString("create.transport.fail.duplicate", "{0} transport already exists. Cannot add duplicate transport"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Transports>(){

                @Override
                public Object run(Transports param) throws PropertyVetoException, TransactionFailure {
                    boolean docrootAdded = false;
                    boolean accessLogAdded = false;
                    Transport newTransport = (Transport)param.createChild(Transport.class);
                    newTransport.setName(CreateTransport.this.transportName);
                    newTransport.setAcceptorThreads(CreateTransport.this.acceptorThreads);
                    newTransport.setBufferSizeBytes(CreateTransport.this.bufferSizeBytes);
                    newTransport.setByteBufferType(CreateTransport.this.byteBufferType);
                    newTransport.setClassname(CreateTransport.this.className);
                    newTransport.setDisplayConfiguration(CreateTransport.this.displayConfiguration.toString());
                    newTransport.setEnableSnoop(CreateTransport.this.enableSnoop.toString());
                    newTransport.setIdleKeyTimeoutSeconds(CreateTransport.this.idleKeyTimeoutSeconds);
                    newTransport.setMaxConnectionsCount(CreateTransport.this.maxConnectionsCount);
                    newTransport.setName(CreateTransport.this.transportName);
                    newTransport.setReadTimeoutMillis(CreateTransport.this.readTimeoutMillis);
                    newTransport.setSelectionKeyHandler(CreateTransport.this.selectionKeyHandler);
                    newTransport.setSelectorPollTimeoutMillis(CreateTransport.this.selectorPollTimeoutMillis);
                    newTransport.setWriteTimeoutMillis(CreateTransport.this.writeTimeoutMillis);
                    newTransport.setTcpNoDelay(CreateTransport.this.tcpNoDelay.toString());
                    param.getTransport().add(newTransport);
                    return newTransport;
                }
            }, transports);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.transport.fail", "Failed to create transport {0} ", new Object[]{this.transportName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

