/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ModelBinding;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-virtual-server")
@Scoped(value=PerLookup.class)
@I18n(value="create.virtual.server")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateVirtualServer
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateVirtualServer.class);
    @Param(name="hosts", defaultValue="${com.sun.aas.hostName}")
    String hosts;
    @Param(name="httplisteners", optional=true)
    String httpListeners;
    @Param(name="networklisteners", optional=true)
    String networkListeners;
    @Param(name="defaultwebmodule", optional=true)
    String defaultWebModule;
    @Param(name="state", defaultValue="on", acceptableValues="on, off, disabled", optional=true)
    String state;
    @Param(name="logfile", optional=true)
    @ModelBinding(type=VirtualServer.class, getterMethodName="getLogFile")
    String logFile;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="virtual_server_id", primary=true)
    String virtualServerId;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        if (this.networkListeners != null && this.httpListeners != null) {
            report.setMessage(localStrings.getLocalString("create.virtual.server.both.http.network", "Please use only networklisteners", new Object[]{this.virtualServerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.networkListeners = this.networkListeners != null ? this.networkListeners : this.httpListeners;
        HttpService httpService = this.config.getHttpService();
        for (VirtualServer virtualServer : httpService.getVirtualServer()) {
            if (!virtualServer.getId().equals(this.virtualServerId)) continue;
            report.setMessage(localStrings.getLocalString("create.virtual.server.duplicate", "Virtual Server named {0} already exists.", new Object[]{this.virtualServerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<HttpService>(){

                @Override
                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    boolean docrootAdded = false;
                    boolean accessLogAdded = false;
                    VirtualServer newVirtualServer = (VirtualServer)param.createChild(VirtualServer.class);
                    newVirtualServer.setId(CreateVirtualServer.this.virtualServerId);
                    newVirtualServer.setHosts(CreateVirtualServer.this.hosts);
                    newVirtualServer.setNetworkListeners(CreateVirtualServer.this.networkListeners);
                    newVirtualServer.setDefaultWebModule(CreateVirtualServer.this.defaultWebModule);
                    newVirtualServer.setState(CreateVirtualServer.this.state);
                    newVirtualServer.setLogFile(CreateVirtualServer.this.logFile);
                    if (CreateVirtualServer.this.properties != null) {
                        for (Map.Entry<Object, Object> entry : CreateVirtualServer.this.properties.entrySet()) {
                            Property property = (Property)newVirtualServer.createChild(Property.class);
                            String pn = (String)entry.getKey();
                            property.setName(pn);
                            property.setValue((String)entry.getValue());
                            newVirtualServer.getProperty().add(property);
                            if ("docroot".equals(pn)) {
                                docrootAdded = true;
                            }
                            if (!"accesslog".equals(pn)) continue;
                            accessLogAdded = true;
                        }
                    }
                    if (!docrootAdded) {
                        Property drp = (Property)newVirtualServer.createChild(Property.class);
                        drp.setName("docroot");
                        drp.setValue("${com.sun.aas.instanceRoot}/docroot");
                        newVirtualServer.getProperty().add(drp);
                    }
                    if (!accessLogAdded) {
                        Property alp = (Property)newVirtualServer.createChild(Property.class);
                        alp.setName("accesslog");
                        alp.setValue("${com.sun.aas.instanceRoot}/logs/access");
                        newVirtualServer.getProperty().add(alp);
                    }
                    param.getVirtualServer().add(newVirtualServer);
                    return newVirtualServer;
                }
            }, httpService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.virutal.server.fail", "{0} create failed ", new Object[]{this.virtualServerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

