/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.FacesLogger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UINamingContainer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class TokenHelper {
    public static final String SECRET_KEY = "secret.key";
    protected static SecureRandom random = null;
    public static final String FORM_CLIENT_ID_ATTRIBUTE_NAME = "com.sun.faces.FORM_CLIENT_ID";
    private static Logger LOGGER = FacesLogger.RENDERKIT.getLogger();

    public static String generateToken(String viewId, Long secretKey) {
        String token = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(viewId.getBytes());
            md.update(secretKey.byteValue());
            token = TokenHelper.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new FacesException((Throwable)e);
        }
        return token;
    }

    public static String getToken(Map requestParameterMap) {
        String token = null;
        for (String keyName : requestParameterMap.keySet()) {
            if (!keyName.contains("javax.faces.Token")) continue;
            token = (String)requestParameterMap.get(keyName);
            break;
        }
        return token;
    }

    public static Long getSecretKey(Map sessionMap) {
        Long key = (Long)sessionMap.get(SECRET_KEY);
        return key;
    }

    public static void setSecretKey(Map sessionMap) throws NoSuchAlgorithmException {
        if (random == null) {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        long key = random.nextLong();
        sessionMap.put(SECRET_KEY, key);
    }

    public static String appendToken(FacesContext facesContext, String viewId, String actionURL) {
        ExternalContext eContext = facesContext.getExternalContext();
        Map sessionMap = eContext.getSessionMap();
        String formClientId = (String)facesContext.getAttributes().get(FORM_CLIENT_ID_ATTRIBUTE_NAME);
        Long secretKey = TokenHelper.getSecretKey(sessionMap);
        if (null == secretKey) {
            try {
                TokenHelper.setSecretKey(sessionMap);
                secretKey = TokenHelper.getSecretKey(sessionMap);
            }
            catch (Exception e) {
                throw new FacesException("Could not generate secret key for token");
            }
        }
        String namingContainerString = "";
        if (null != formClientId) {
            namingContainerString = formClientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        }
        String appendedURL = actionURL + "?" + namingContainerString + "javax.faces.Token" + "=" + TokenHelper.generateToken(viewId, secretKey);
        return appendedURL;
    }

    public static boolean verifyToken(FacesContext facesContext, String viewId) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        Map sessionMap = externalContext.getSessionMap();
        String token = TokenHelper.getToken(requestParameterMap);
        if (null == token) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Token not found in request");
            }
            return false;
        }
        Long secretKey = TokenHelper.getSecretKey(sessionMap);
        if (null == secretKey) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Secret Key not set");
            }
            return false;
        }
        if (!token.equals(TokenHelper.generateToken(viewId, secretKey))) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Token verification failed");
            }
            return false;
        }
        return true;
    }

    private static String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(Character.forDigit((buffer[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(buffer[i] & 0xF, 16));
        }
        return sb.toString();
    }
}

