/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijpa;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijpa.JPABundleProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class JPAExtender
implements Extender,
SynchronousBundleListener {
    private Logger logger = Logger.getLogger(JPAExtender.class.getPackage().getName());
    private BundleContext context;
    private final ServiceTracker tracker;

    public JPAExtender(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.tracker.open();
    }

    public void start() {
        this.context.addBundleListener((BundleListener)this);
        this.logger.logp(Level.INFO, "JPAExtender", "start", " JPAExtender started", new Object[0]);
    }

    public void stop() {
        this.context.removeBundleListener((BundleListener)this);
        this.logger.logp(Level.INFO, "JPAExtender", "stop", " JPAExtender stopped", new Object[0]);
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 1: 
            case 8: {
                JPABundleProcessor bi = new JPABundleProcessor(bundle);
                if (bi.isEnhanced() || !bi.isJPABundle()) break;
                this.logger.logp(Level.INFO, "JPAExtender", "bundleChanged", "Bundle having id {0} is a JPA bundle", new Object[]{bundle.getBundleId()});
                try {
                    bi.enhance();
                    this.getPackageAdmin().refreshPackages(new Bundle[]{bundle});
                }
                catch (Exception e) {
                    this.logger.logp(Level.WARNING, "JPAExtender", "bundleChanged", "Failed to enhance bundle having id " + bundle.getBundleId(), e);
                }
                break;
            }
        }
    }

    private PackageAdmin getPackageAdmin() {
        return (PackageAdmin)PackageAdmin.class.cast(this.tracker.getService());
    }
}

