/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.embedded;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class EmbeddedSecurityUtil
implements EmbeddedSecurity {
    private static final Logger _logger = LogDomains.getLogger(EmbeddedSecurityUtil.class, (String)"javax.enterprise.system.core.security");

    @Override
    public void copyConfigFiles(Habitat habitat, File fromInstanceDir, File domainXml) {
        ServerEnvironment se = habitat.getComponent(ServerEnvironment.class);
        if (!this.isEmbedded(se)) {
            return;
        }
        if (fromInstanceDir == null || domainXml == null) {
            throw new IllegalArgumentException("Null inputs");
        }
        File toInstanceDir = habitat.getComponent(ServerEnvironmentImpl.class).getInstanceRoot();
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            EmbeddedSecurityUtil embeddedSecurityUtil = new EmbeddedSecurityUtil();
            embeddedSecurityUtil.getClass();
            fileNames.addAll(embeddedSecurityUtil.new DomainXmlSecurityParser(domainXml).getAbsolutePathKeyFileNames(fromInstanceDir));
            String keyStoreFileName = fromInstanceDir + File.separator + "config" + File.separator + "keystore.jks";
            String trustStoreFileName = fromInstanceDir + File.separator + "config" + File.separator + "cacerts.jks";
            fileNames.add(keyStoreFileName);
            fileNames.add(trustStoreFileName);
            String loginConf = fromInstanceDir + File.separator + "config" + File.separator + "login.conf";
            String secPolicy = fromInstanceDir + File.separator + "config" + File.separator + "server.policy";
            fileNames.add(loginConf);
            fileNames.add(secPolicy);
            File toConfigDir = new File(toInstanceDir, "config");
            if (!toConfigDir.exists()) {
                toConfigDir.mkdir();
            }
            for (String fileName : fileNames) {
                FileUtils.copyFile((File)new File(fileName), (File)new File(toConfigDir, this.parseFileName(fileName)));
            }
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, "", e);
        }
        catch (XMLStreamException e) {
            _logger.log(Level.WARNING, "", e);
        }
    }

    @Override
    public String parseFileName(String fullFilePath) {
        if (fullFilePath == null) {
            return null;
        }
        File file = new File(fullFilePath);
        return file.getName();
    }

    @Override
    public boolean isEmbedded(ServerEnvironment se) {
        return se.getRuntimeType() == RuntimeType.EMBEDDED;
    }

    @Override
    public List<String> getKeyFileNames(SecurityService securityService) {
        ArrayList<String> keyFileNames = new ArrayList<String>();
        List authRealms = securityService.getAuthRealm();
        for (AuthRealm authRealm : authRealms) {
            String className = authRealm.getClassname();
            if (!"com.sun.enterprise.security.auth.realm.file.FileRealm".equals(className)) continue;
            List props = authRealm.getProperty();
            for (Property prop : props) {
                if (!"file".equals(prop.getName())) continue;
                keyFileNames.add(prop.getValue());
            }
        }
        return keyFileNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DomainXmlSecurityParser {
        XMLStreamReader xmlReader;
        XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newInstance() : XMLInputFactory.newInstance(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
        private static final String AUTH_REALM = "auth-realm";
        private static final String CONFIG = "config";
        private static final String CLASSNAME = "classname";
        private static final String FILE_REALM_CLASS = "com.sun.enterprise.security.auth.realm.file.FileRealm";
        private static final String PROPERTY = "property";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        private static final String FILE = "file";
        private static final String INSTANCE_DIR_PLACEHOLDER = "${com.sun.aas.instanceRoot}";

        DomainXmlSecurityParser(File domainXml) throws XMLStreamException, FileNotFoundException {
            this.xmlReader = this.xif.createXMLStreamReader(new FileReader(domainXml));
        }

        private String replaceInstanceDir(String fromInstanceDir, String keyFileName) {
            return StringUtils.replace((String)keyFileName, (String)INSTANCE_DIR_PLACEHOLDER, (String)fromInstanceDir);
        }

        List<String> getAbsolutePathKeyFileNames(File fromInstanceDir) throws XMLStreamException {
            ArrayList<String> keyFileNames = new ArrayList<String>();
            while (this.skipToStartButNotPast(AUTH_REALM, CONFIG)) {
                String realmClass = this.xmlReader.getAttributeValue(null, CLASSNAME);
                if (!realmClass.equals(FILE_REALM_CLASS)) continue;
                while (this.skipToStartButNotPast(PROPERTY, AUTH_REALM)) {
                    if (!FILE.equals(this.xmlReader.getAttributeValue(null, NAME))) continue;
                    String keyFileName = this.xmlReader.getAttributeValue(null, VALUE);
                    keyFileNames.add(this.replaceInstanceDir(fromInstanceDir.getAbsolutePath(), keyFileName));
                }
            }
            return keyFileNames;
        }

        private boolean skipToStartButNotPast(String startName, String stopName) throws XMLStreamException {
            if (!StringUtils.ok((String)startName) || !StringUtils.ok((String)stopName)) {
                throw new IllegalArgumentException();
            }
            while (this.xmlReader.hasNext()) {
                this.xmlReader.next();
                if (this.xmlReader.isStartElement() && startName.equals(this.xmlReader.getLocalName())) {
                    return true;
                }
                if (!this.xmlReader.isEndElement() || !stopName.equals(this.xmlReader.getLocalName())) continue;
                return false;
            }
            return false;
        }
    }
}

