/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="list-system-properties")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
@I18n(value="list.system.properties")
public class ListSystemProperties
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListSystemProperties.class);
    @Param(optional=true, primary=true, defaultValue="server")
    String target;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Domain spb;
        ActionReport report = context.getActionReport();
        Property domainProp = this.domain.getProperty("administrative.domain.name");
        String domainName = domainProp.getValue();
        if ("domain".equals(this.target) || this.target.equals(domainName)) {
            spb = this.domain;
        } else {
            spb = this.domain.getConfigNamed(this.target);
            if (spb == null) {
                spb = this.domain.getClusterNamed(this.target);
            }
            if (spb == null) {
                spb = this.domain.getServerNamed(this.target);
            }
        }
        if (spb == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets types are domain, config, cluster, default server, clustered instance, stand alone instance", new Object[]{this.target});
            report.setMessage(msg);
            return;
        }
        try {
            List sysProps = spb.getSystemProperty();
            int length = 0;
            if (sysProps.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("NothingToList", "Nothing to List."));
            } else {
                for (SystemProperty prop : sysProps) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(prop.getName() + "=" + prop.getValue());
                    ++length;
                }
                report.setMessage(localStrings.getLocalString("list.ok", "The target {0} contains following {1} system properties", new Object[]{this.target, length}));
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.system.properties.failed", "list-system-properties failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

