/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jvm-options")
@Scoped(value=PerLookup.class)
@I18n(value="list.jvm.options")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public final class ListJvmOptions
implements AdminCommand {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="profiler", optional=true)
    Boolean profiler = false;
    @Inject
    Target targetService;
    @Inject(name="default-instance-name")
    Config config;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    private static final Logger logger = Logger.getLogger(ListJvmOptions.class.getPackage().getName());

    public void execute(AdminCommandContext context) {
        List opts;
        ActionReport report = context.getActionReport();
        Config targetConfig = this.targetService.getConfig(this.target);
        if (targetConfig != null) {
            this.config = targetConfig;
        }
        JavaConfig jc = this.config.getJavaConfig();
        if (this.profiler.booleanValue()) {
            if (jc.getProfiler() == null) {
                report.setMessage(lsm.getString("create.profiler.first"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            opts = jc.getProfiler().getJvmOptions();
        } else {
            opts = jc.getJvmOptions();
        }
        try {
            for (String option : opts) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(option);
            }
        }
        catch (Exception e) {
            report.setMessage(lsm.getStringWithDefault("list.jvm.options.failed", "Command: list-jvm-options failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

