/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.LifecycleEventContextImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.loader.util.ASClassLoaderUtil;

public final class ServerLifecycleModule {
    private LifecycleListener slcl;
    private String name;
    private String className;
    private String classpath;
    private int loadOrder;
    private boolean isFatal = false;
    private String statusMsg = "OK";
    private ServerContext ctx;
    private LifecycleEventContext leContext;
    private ClassLoader urlClassLoader;
    private Properties props = new Properties();
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;
    private static final String LIFECYCLE_PREFIX = "lifecycle_";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServerLifecycleModule.class);

    ServerLifecycleModule(ServerContext ctx, String name, String className) {
        this.name = name;
        this.className = className;
        this.ctx = ctx;
        this.leContext = new LifecycleEventContextImpl(ctx);
        _logger = LogDomains.getLogger(ServerLifecycleModule.class, (String)"javax.enterprise.system.core");
        _isTraceEnabled = _logger.isLoggable(Level.FINE);
    }

    void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    void setProperty(String name, String value) {
        this.props.put(name, value);
    }

    Properties getProperties() {
        return this.props;
    }

    void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    void setIsFatal(boolean isFatal) {
        this.isFatal = isFatal;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getClasspath() {
        return this.classpath;
    }

    int getLoadOrder() {
        return this.loadOrder;
    }

    boolean isFatal() {
        return this.isFatal;
    }

    LifecycleListener loadServerLifecycle() throws ServerLifecycleException {
        ClassLoader classLoader = this.ctx.getLifecycleParentClassLoader();
        try {
            if (this.classpath != null) {
                URL[] urls = this.getURLs();
                if (urls != null) {
                    StringBuffer sb = new StringBuffer(128);
                    for (int i = 0; i < urls.length; ++i) {
                        sb.append(urls[i].toString());
                    }
                    if (_isTraceEnabled) {
                        _logger.fine("Lifecycle module = " + this.getName() + " has classpath URLs = " + sb.toString());
                    }
                }
                classLoader = this.urlClassLoader = new URLClassLoader(urls, classLoader);
            }
            Class<?> cl = Class.forName(this.className, true, classLoader);
            this.slcl = (LifecycleListener)cl.newInstance();
        }
        catch (Exception ee) {
            _logger.log(Level.WARNING, localStrings.getLocalString("lifecyclemodule.load_exception", "Exception loading lifecycle module", new Object[]{this.name, ee.toString()}), ee);
        }
        return this.slcl;
    }

    private URL[] getURLs() {
        List urlList = ASClassLoaderUtil.getURLsFromClasspath((String)this.classpath, (String)File.pathSeparator, (String)"");
        return ASClassLoaderUtil.convertURLListToArray((List)urlList);
    }

    private void postEvent(int eventType, Object data) throws ServerLifecycleException {
        block7: {
            if (this.slcl == null) {
                if (this.isFatal) {
                    throw new ServerLifecycleException(localStrings.getLocalString("lifecyclemodule.loadExceptionIsFatal", "Treating failure loading the lifecycle module as fatal", new Object[]{this.name}));
                }
                return;
            }
            if (this.urlClassLoader != null) {
                this.setClassLoader();
            }
            LifecycleEvent slcEvent = new LifecycleEvent(this, eventType, data, this.leContext);
            try {
                this.slcl.handleEvent(slcEvent);
            }
            catch (ServerLifecycleException sle) {
                _logger.log(Level.WARNING, localStrings.getLocalString("lifecyclemodule.event_ServerLifecycleException", "Lifecycle module threw ServerLifecycleException", new Object[]{this.name}), sle);
                if (this.isFatal) {
                    throw sle;
                }
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, localStrings.getLocalString("lifecyclemodule.event_Exception", "Lifecycle module threw an Exception", new Object[]{this.name}), ee);
                if (!this.isFatal) break block7;
                throw new ServerLifecycleException(localStrings.getLocalString("lifecyclemodule.event_exceptionIsFatal", "Treating the exception from lifecycle module event handler as fatal"), ee);
            }
        }
    }

    public void onInitialization() throws ServerLifecycleException {
        this.postEvent(0, this.props);
    }

    public void onStartup() throws ServerLifecycleException {
        this.postEvent(1, this.props);
    }

    public void onReady() throws ServerLifecycleException {
        this.postEvent(2, this.props);
    }

    public void onShutdown() throws ServerLifecycleException {
        this.postEvent(3, this.props);
    }

    public void onTermination() throws ServerLifecycleException {
        this.postEvent(4, this.props);
    }

    private void setClassLoader() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ServerLifecycleModule.this.urlClassLoader);
                return null;
            }
        });
    }

    public String getStatus() {
        return this.statusMsg;
    }

    public String toString() {
        return "Server LifecycleListener support";
    }
}

