/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.PortUnification;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolFinder;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-protocol-finder")
@Scoped(value=PerLookup.class)
@I18n(value="create.protocol.finder")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateProtocolFinder
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateProtocolFinder.class);
    @Param(name="name", primary=true)
    String name;
    @Param(name="protocol", optional=false)
    String protocolName;
    @Param(name="targetprotocol", optional=false)
    String targetName;
    @Param(name="classname", optional=false)
    String classname;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    private ActionReport report;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        this.report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = protocols.findProtocol(this.protocolName);
        Protocol target = protocols.findProtocol(this.targetName);
        try {
            this.validate((ConfigBeanProxy)protocol, "create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", this.protocolName);
            this.validate((ConfigBeanProxy)target, "create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured", this.targetName);
            Class<?> finderClass = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
            if (!com.sun.grizzly.portunif.ProtocolFinder.class.isAssignableFrom(finderClass)) {
                this.report.setMessage(localStrings.getLocalString("create.portunif.fail.notfinder", "{0} create failed.  Given class is not a ProtocolFinder: {1}", new Object[]{this.name, this.classname}));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            PortUnification unif = (PortUnification)ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws PropertyVetoException, TransactionFailure {
                    PortUnification pu = param.getPortUnification();
                    if (pu == null) {
                        pu = (PortUnification)param.createChild(PortUnification.class);
                        param.setPortUnification(pu);
                    }
                    return pu;
                }
            }, protocol);
            ConfigSupport.apply(new SingleConfigCode<PortUnification>(){

                @Override
                public Object run(PortUnification param) throws PropertyVetoException, TransactionFailure {
                    List list = param.getProtocolFinder();
                    for (ProtocolFinder finder : list) {
                        if (!CreateProtocolFinder.this.name.equals(finder.getName())) continue;
                        throw new TransactionFailure(String.format("A protocol finder named %s already exists.", CreateProtocolFinder.this.name));
                    }
                    ProtocolFinder finder = (ProtocolFinder)param.createChild(ProtocolFinder.class);
                    finder.setName(CreateProtocolFinder.this.name);
                    finder.setProtocol(CreateProtocolFinder.this.targetName);
                    finder.setClassname(CreateProtocolFinder.this.classname);
                    list.add(finder);
                    return null;
                }
            }, unif);
        }
        catch (ValidationFailureException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.setMessage(localStrings.getLocalString("create.portunif.fail", "{0} create failed: {1}", new Object[]{this.name, e.getMessage() == null ? "No reason given" : e.getMessage()}));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
            return;
        }
    }

    private void validate(ConfigBeanProxy check, String key, String defaultFormat, String ... arguments) throws ValidationFailureException {
        if (check == null) {
            this.report.setMessage(localStrings.getLocalString(key, defaultFormat, (Object[])arguments));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new ValidationFailureException();
        }
    }

    private class ValidationFailureException
    extends Exception {
        private ValidationFailureException() {
        }
    }
}

